"use client";

import TitlePage from "@/app/components/common/TitlePage";
import GallerySlider from "../components/GallerySlider";
import type { GalleryDetailData } from "@/app/(sections)/gallery/types/galleryDetail";
import type { GallerySliderItem } from "@/app/(sections)/gallery/types/gallery";
type Props = {
  pageInfo: GalleryDetailData["pageInfo"];
  items: GallerySliderItem[];
};

export default function GalleryDetailPage({ pageInfo, items }: Props) {
  return (
    <div className="galleryDetailPage">
      <div className="mainSmall">

        <TitlePage title={`تصاویر ${pageInfo.title}`} />

        <section className="galleryImg">
          <GallerySlider items={items} />
        </section>

      </div>
    </div>
  );
}
