"use client";

import { useRouter } from "next/navigation";
import CategorySlider from "@/app/components/common/CategorySlider";
import Pagination from "@/app/components/common/Pagination";
import TitlePage from "@/app/components/common/TitlePage";
import type {
  GalleryCategory,
  GalleryItem,
  GalleryPagination,
} from "@/app/(sections)/gallery/types/gallery";
import Link from "next/link";

type GalleryPageProps = {
  title: string;
  categories: GalleryCategory[];
  items: GalleryItem[];
  pagination: GalleryPagination;
  selectedCategory: string;
};

export default function GalleryPage({
  title,
  categories,
  items,
  pagination,
  selectedCategory,
}: GalleryPageProps) {
  const router = useRouter();

  const handlePageChange = (page: number) => {
    const url =
      `/gallery?page=${page}` +
      (selectedCategory ? `&category=${selectedCategory}` : "");
    router.push(url);
  };

  return (
    <div className="galleryPage">
      <div className="mainSmall">
        <TitlePage title={title} />

        {/* -------------------- Category -------------------- */}
        <section className="galleryPage_cat">
          <CategorySlider
            categories={categories.map((c, index) => ({
              id: c.id,
              slug: c.slug,
              label: c.title,
              icon: undefined,
              isFirst: index === 0,
            }))}

            basePath="/gallery/list"

            selectedCategory={selectedCategory}
          />
        </section>

        {/* --------------------  Gallery List -------------------- */}
        <section className="galleryPage_list">
          <div className="galleryList">
            <ul>
              {items.map((item) => (
                <li key={item.slug}>
                  <Link href={`/gallery/${item.slug}`} className="galleryList_item relative">
                    <div className="galleryList_item_img relative">
                      <figure className="radius35 w100 h100 overflow hoverImg">
                        <img
                          src={item.picture}
                          alt={item.title}
                          className="w100 h100 objectfitCover"
                        />
                      </figure>
                    </div>

                    <div className="galleryList_item_desc txtCenter relative">
                      <h2>{item.title}</h2>
                    </div>
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {pagination.totalPages > 1 && (
            <Pagination
              currentPage={pagination.pageNumber}
              totalPages={pagination.totalPages}
              onPageChange={handlePageChange}
            />
          )}
        </section>
      </div>
    </div>
  );
}
