"use client";

import { useEffect, useState, useRef } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Thumbs, EffectCoverflow } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/thumbs";
import "swiper/css/effect-coverflow";
import { Fancybox } from "@fancyapps/ui";
import "@fancyapps/ui/dist/fancybox/fancybox.css";
import type { GallerySliderItem } from "@/app/(sections)/gallery/types/gallery";

interface Props {
  items: GallerySliderItem[];
}

export default function GallerySlider({ items }: Props) {
  const [thumbsSwiper, setThumbsSwiper] = useState<any>(null);
  const topSwiperRef = useRef<any>(null);
  const galleryRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    if (galleryRef.current) {
      Fancybox.bind(
        galleryRef.current.querySelectorAll("[data-fancybox='gallery']"),
        {
          on: {
            close: () => {
              topSwiperRef.current?.update();
              thumbsSwiper?.update();
            },
          },
        }
      );
    }

    return () => {
      Fancybox.destroy();
    };
  }, [thumbsSwiper]);

  return (
    <div className="galleryImg" ref={galleryRef}>
      {/* Main Slider */}
      <div className="galleryImg_top">
        <Swiper
          modules={[Thumbs, EffectCoverflow]}
          effect="coverflow"
          grabCursor
          centeredSlides
          slidesPerView={1.4}
          spaceBetween={20}
          coverflowEffect={{
            rotate: 30,
            stretch: 0,
            depth: 200,
            modifier: 1,
            slideShadows: true,
          }}
          thumbs={{ swiper: thumbsSwiper }}
          className="galleryImg_top_slider"
          onSwiper={(swiper) => (topSwiperRef.current = swiper)}
          observer
          observeParents
        >
          {items.map((item, i) => (
            <SwiperSlide key={i}>
              <a
                href={item.src}
                data-fancybox="gallery"
                data-type={item.type === "video" ? "video" : "image"}
                className="galleryImg_top_item radius32 relative"
              >
                <img
                  src={item.type === "image" ? item.src : "/video-thumb.jpg"} 
                  alt=""
                  className="w100 h100 objectfitCover radius32"
                />

                {item.type === "video" && (
                  <div className="videoPlayIcon">▶</div>
                )}
              </a>
            </SwiperSlide>
          ))}
        </Swiper>
      </div>

      {/* Bottom Slider */}
      <div className="galleryImg_bottom relative">
        <Swiper
          modules={[Navigation, Thumbs]}
          onSwiper={setThumbsSwiper}
          slidesPerView={7}
          spaceBetween={16}
          watchSlidesProgress
          navigation={{
            nextEl: ".galleryImg_bottom_nextBtn",
            prevEl: ".galleryImg_bottom_prevBtn",
          }}
          breakpoints={{
            300: { slidesPerView: 4, spaceBetween: 10 },
            480: { slidesPerView: 4, spaceBetween: 10 },
            720: { slidesPerView: 6, spaceBetween: 10 },
            1000: { slidesPerView: 7 },
          }}
          className="galleryImg_bottom_slider"
          observer
          observeParents
        >
          {items.map((item, i) => (
            <SwiperSlide key={i}>
              <figure className="galleryImg_bottom_item radius12 relative">
                <img
                  src={item.type === "image" ? item.src : "/video-thumb.jpg"}
                  alt=""
                  className="w100 h100 radius12"
                />
                {item.type === "video" && (
                  <div className="videoPlayIconSmall">▶</div>
                )}
              </figure>
            </SwiperSlide>
          ))}
        </Swiper>

        <div className="galleryImg_bottom_nextBtn publicBtn absolute">
          <i className="fa-light fa-chevron-right"></i>
        </div>
        <div className="galleryImg_bottom_prevBtn publicBtn absolute">
          <i className="fa-light fa-angle-left"></i>
        </div>
      </div>
    </div>
  );
}
