import { getGalleryList } from "@/src/lib/galleryApi";
import GalleryPage from "./components/GalleryPage";
import type { Metadata } from "next";

export async function generateMetadata({ searchParams }: any): Promise<Metadata> {
  const params = await searchParams;
  const page = Number(params?.page ?? 1);
  const category = params?.category ?? "";

  try {
    const data = await getGalleryList(page, category);
    const p = data.pageInfo;

    return {
      title: p.title || p.title || "گالری تصاویر",
      description: p.description || "",
      openGraph: {
        title: p.ogTitle || p.title,
        description: p.ogDescription || "",
        images: p.ogImage ? [{ url: p.ogImage }] : [],
      },
      alternates: {
        canonical: p.canonical || "/gallery",
      },
      robots: p.pageRobotsStatus || undefined,
    };
  } catch {
    return {
      title: "گالری تصاویر",
    };
  }
}

export default async function Page({ searchParams }: any) {
  const params = await searchParams;
  const page = Number(params?.page ?? 1);
  const category = params?.category ?? "";

  const data = await getGalleryList(page, category);

  return (
    <GalleryPage
      title={data.pageInfo.title}
      categories={data.categories}
      items={data.items}
      pagination={data.pagination}
      selectedCategory={category}
    />
  );
}
