export interface GalleryCategory {
  id: string;
  title: string;
  slug: string;
}

export interface GalleryItem {
  title: string;
  picture: string;
  slug: string;
}

export interface GalleryPagination {
  pageNumber: number;
  pageSize: number;
  totalPages: number;
  totalCount: number;
  hasNextPage: boolean;
  hasPreviousPage: boolean;
}

export interface GalleryListData {
  pageInfo: {
    title: string;
    description: string;
    canonical: string;
    ogTitle: string;
    ogDescription: string;
    ogImage: string;
    pageRobotsStatus?: string | null; 
  };
  categories: GalleryCategory[];
  items: GalleryItem[];
  pagination: GalleryPagination;
}
export type GallerySliderItem = {
  src: string; 
  type: "image" | "video";
  title?: string;
};