"use client";

import { useState } from "react";

export default function CommentPopup() {
  const [rating, setRating] = useState<number | null>(null);

  return (
    <section className="popupComment_content">
      {/* --- Popup Title --- */}
      <div className="popupComment_Head flex flexSpace alignCenter">
        <div className="boldTitle">
          <strong>افزودن نظر</strong>
        </div>
      </div>
<div className="newsTitle radius14 borderLightGray flex flexSpace alignCenter">
  <figure className="newsTitle_img radius12 overflow">
    <img
      src="/images/popupNewsImg.png"
      alt=""
      className="w100 h100 objectfitCover"
    />
  </figure>

  <figcaption className="newsTitle_txt">
    <h2 className="darkTxt">کم شنوایی ناشی از سر و صدا چیست ؟</h2>

    <div className="date flex flexStart alignCenter">
      <div className="itemIcon">
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="14"
          height="16"
          viewBox="0 0 14 16"
          fill="none"
        >
          <path
            d="M1.0625 6.68896H12.9451"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M9.95703 9.46655H9.96321"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M7 9.4668H7.00618"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M4.04297 9.46655H4.04914"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M9.95703 12.228H9.96321"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M7 12.228H7.00618"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M4.04297 12.228H4.04914"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M9.69922 1.42236V3.76247"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M4.3125 1.42236V3.76247"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.82551 2.54468H4.18064C2.22285 2.54468 1 3.70801 1 5.84639V12.2817C1 14.4537 2.22285 15.6439 4.18064 15.6439H9.81933C11.7833 15.6439 13 14.4739 13 12.3355V5.84639C13.0062 3.70801 11.7895 2.54468 9.82551 2.54468Z"
            stroke="#888888"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
        </svg>
      </div>

      <time className="time">16 اسفند 1403</time>
    </div>
  </figcaption>
</div>

      {/* --- Form --- */}
      <div className="popupForm publicForm w100">
        <form
          onSubmit={(e) => {
            e.preventDefault();
            console.log("✅ فرم ارسال شد");
          }}
          className="w100"
        >
          <ul className="flex flexSpace alignCenter w100 flexWrap gap16">
            <li className="w45">
              <label htmlFor="firstName">نام</label>
              <input
                className="txt w100 borderLightGray"
                type="text"
                placeholder="نام را وارد نمایید..."
                id="firstName"
                required
              />
            </li>

            <li className="w45">
              <label htmlFor="lastName">نام خانوادگی</label>
              <input
                className="txt w100 borderLightGray"
                type="text"
                placeholder="نام خانوادگی را وارد نمایید..."
                id="lastName"
                required
              />
            </li>

       {/* --- Score --- */}
<li className="w100">
  <div className="txtCenter darkTxt w100 mb8">
    <label>به این وبلاگ امتیاز دهید</label>
  </div>

<ul className="emojiList flex flexCenter alignCenter">
  {[1, 2, 3, 4, 5].map((num) => (
    <li
      key={num}
      className={`
        ${rating === num ? "active" : ""}
      `}
      onClick={() => setRating(num)}
      style={{ cursor: "pointer" }}
    >
      <div className="emojiList_item radius12 lightGrayBg flex flexCenter alignCenter">
        <figure className="StickerItem pointer-events-none">
          {num === 1 && (
            <>
              <div className="StickerItem_disable flex flexCenter alignCenter">
              {/* SVG #1 - Disabled */}
                <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                    <path d="M40.9995 20.5128C40.9995 31.8491 31.8526 41 20.5213 41C9.18994 41 0.0429688 31.8491 0.0429688 20.5128C0.0429688 9.17658 9.18994 0.0256348 20.5213 0.0256348C31.8526 0.0256348 40.9995 9.17658 40.9995 20.5128Z" fill="#D1D1D1"/>
                    <path d="M40.8631 7.67374C40.5218 5.8299 39.4978 4.3275 37.7913 3.84947C35.9483 3.37143 34.31 4.05434 32.74 5.69332C31.8526 3.23485 30.4874 1.39101 28.303 0.434938C26.1187 -0.521131 23.9343 0.161775 22.5691 1.86904C21.1356 3.6446 20.5896 6.44451 22.0913 10.0639C23.5248 13.4784 29.873 20.3075 30.0778 20.5124C30.3509 20.3758 37.45 15.9369 39.1565 13.7516C40.8631 11.6346 41.2044 9.51759 40.8631 7.67374ZM18.4735 1.86904C17.1083 0.161775 14.9239 -0.521131 12.7396 0.434938C10.5552 1.39101 9.18998 3.23485 8.30259 5.69332C6.66433 4.12263 5.02607 3.37143 3.18302 3.91776C1.54476 4.39579 0.452582 5.89819 0.111278 7.74203C-0.230027 9.51759 0.179538 11.7029 1.8178 13.8199C3.59259 15.9369 10.6917 20.3758 10.9648 20.5124C11.1696 20.3075 17.5178 13.4784 18.9513 10.0639C20.453 6.44451 19.907 3.71289 18.4735 1.86904Z" fill="#888888"/>
                    <path d="M32.1267 24.6781C32.1267 24.1318 31.7854 23.4489 30.898 23.244C28.5089 22.7659 25.0276 22.3562 20.5223 22.3562C16.0171 22.3562 12.5358 22.8342 10.1467 23.244C9.19101 23.4489 8.91797 24.1318 8.91797 24.6781C8.91797 29.6633 12.7406 34.6485 20.5223 34.6485C28.3041 34.5802 32.1267 29.595 32.1267 24.6781Z" fill="#4F4F4F"/>
                    <path d="M29.1906 24.8143C27.6889 24.5411 24.5489 24.1313 20.5215 24.1313C16.4941 24.1313 13.3541 24.5411 11.8523 24.8143C10.9649 24.9508 10.8967 25.2923 10.9649 25.8386C11.0332 26.1118 11.0332 26.5215 11.1697 26.9313C11.238 27.341 11.3745 27.5459 12.0571 27.4776C13.3541 27.341 27.7571 27.341 29.0541 27.4776C29.7367 27.5459 29.805 27.341 29.9415 26.9313C30.0098 26.5215 30.078 26.1801 30.1463 25.8386C30.1463 25.2923 30.078 24.9508 29.1906 24.8143Z" fill="white"/>
                  </svg>
              </div>
              <div className="StickerItem_enable flex flexCenter alignCenter">
              {/* SVG #1 - Active */}
                 <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                    <path d="M40.9995 20.5128C40.9995 31.8491 31.8526 41 20.5213 41C9.18994 41 0.0429688 31.8491 0.0429688 20.5128C0.0429688 9.17658 9.18994 0.0256348 20.5213 0.0256348C31.8526 0.0256348 40.9995 9.17658 40.9995 20.5128Z" fill="#FFED4E"/>
                    <path d="M40.8631 7.67374C40.5218 5.8299 39.4978 4.3275 37.7913 3.84947C35.9483 3.37143 34.31 4.05434 32.74 5.69332C31.8526 3.23485 30.4874 1.39101 28.303 0.434938C26.1187 -0.521131 23.9343 0.161775 22.5691 1.86904C21.1356 3.6446 20.5896 6.44451 22.0913 10.0639C23.5248 13.4784 29.873 20.3075 30.0778 20.5124C30.3509 20.3758 37.45 15.9369 39.1565 13.7516C40.8631 11.6346 41.2044 9.51759 40.8631 7.67374ZM18.4735 1.86904C17.1083 0.161775 14.9239 -0.521131 12.7396 0.434938C10.5552 1.39101 9.18998 3.23485 8.30259 5.69332C6.66433 4.12263 5.02607 3.37143 3.18302 3.91776C1.54476 4.39579 0.452582 5.89819 0.111278 7.74203C-0.230027 9.51759 0.179539 11.7029 1.8178 13.8199C3.59259 15.9369 10.6917 20.3758 10.9648 20.5124C11.1696 20.3075 17.5178 13.4784 18.9513 10.0639C20.453 6.44451 19.907 3.71289 18.4735 1.86904Z" fill="#FF5454"/>
                    <path d="M32.1267 24.6781C32.1267 24.1318 31.7854 23.4489 30.898 23.244C28.5089 22.7659 25.0276 22.3562 20.5223 22.3562C16.0171 22.3562 12.5358 22.8342 10.1467 23.244C9.19101 23.4489 8.91797 24.1318 8.91797 24.6781C8.91797 29.6633 12.7406 34.6485 20.5223 34.6485C28.3041 34.5802 32.1267 29.595 32.1267 24.6781Z" fill="#4F4F4F"/>
                    <path d="M29.1906 24.8143C27.6889 24.5411 24.5489 24.1313 20.5215 24.1313C16.4941 24.1313 13.3541 24.5411 11.8523 24.8143C10.9649 24.9508 10.8967 25.2923 10.9649 25.8386C11.0332 26.1118 11.0332 26.5215 11.1697 26.9313C11.238 27.341 11.3745 27.5459 12.0571 27.4776C13.3541 27.341 27.7571 27.341 29.0541 27.4776C29.7367 27.5459 29.805 27.341 29.9415 26.9313C30.0098 26.5215 30.078 26.1801 30.1463 25.8386C30.1463 25.2923 30.078 24.9508 29.1906 24.8143Z" fill="white"/>
                  </svg>
              </div>
            </>
          )}

          {num === 2 && (
            <>
              <div className="StickerItem_disable flex flexCenter alignCenter">
                {/* SVG #2 - Disabled */}
                  <svg xmlns="http://www.w3.org/2000/svg" width="49" height="49" viewBox="0 0 49 49" fill="none">
                      <g filter="url(#filter0_d_844_709)">
                      <path d="M24.5 41C35.8218 41 45 31.8218 45 20.5C45 9.17816 35.8218 0 24.5 0C13.1782 0 4 9.17816 4 20.5C4 31.8218 13.1782 41 24.5 41Z" fill="#D1D1D1"/>
                      <path d="M16.6413 18.7913C18.5282 18.7913 20.0579 17.2616 20.0579 15.3747C20.0579 13.4877 18.5282 11.958 16.6413 11.958C14.7543 11.958 13.2246 13.4877 13.2246 15.3747C13.2246 17.2616 14.7543 18.7913 16.6413 18.7913Z" fill="#6D6D6D"/>
                      <path d="M32.3581 18.7913C34.245 18.7913 35.7747 17.2616 35.7747 15.3747C35.7747 13.4877 34.245 11.958 32.3581 11.958C30.4711 11.958 28.9414 13.4877 28.9414 15.3747C28.9414 17.2616 30.4711 18.7913 32.3581 18.7913Z" fill="#6D6D6D"/>
                      <path d="M36.1161 24.5998C36.1161 24.0532 35.7745 23.3698 34.8861 23.1648C32.4945 22.6865 29.0095 22.2765 24.4995 22.2765C19.9895 22.2765 16.5045 22.7548 14.1128 23.1648C13.2245 23.3698 12.8828 24.0532 12.8828 24.5998C12.8828 29.5882 16.7095 34.5765 24.4995 34.5765C32.2895 34.5765 36.1161 29.5882 36.1161 24.5998Z" fill="#4F4F4F"/>
                      <path d="M33.1787 24.8053C31.6754 24.5319 28.5321 24.1219 24.5004 24.1219C20.4687 24.1219 17.3254 24.5319 15.8221 24.8053C14.9337 24.9419 14.8654 25.2836 14.9337 25.8303C15.0021 26.1036 15.0021 26.5136 15.1387 26.9236C15.2071 27.3336 15.3437 27.5386 16.0271 27.4703C17.3254 27.3336 31.7437 27.3336 33.0421 27.4703C33.7254 27.5386 33.7937 27.3336 33.9304 26.9236C33.9987 26.5136 34.0671 26.1719 34.1354 25.8303C34.1354 25.2836 34.0671 24.9419 33.1787 24.8053Z" fill="white"/>
                      </g>
                      <defs>
                      <filter id="filter0_d_844_709" x="0" y="0" width="49" height="49" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                      <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                      <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                      <feOffset dy="4"/>
                      <feGaussianBlur stdDeviation="2"/>
                      <feComposite in2="hardAlpha" operator="out"/>
                      <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                      <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_844_709"/>
                      <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_844_709" result="shape"/>
                      </filter>
                      </defs>
                 </svg>
              </div>
              <div className="StickerItem_enable flex flexCenter alignCenter">
                {/* SVG #2 - Active */}
                <svg xmlns="http://www.w3.org/2000/svg" width="49" height="49" viewBox="0 0 49 49" fill="none">
                        <g filter="url(#filter0_d_844_709)">
                        <path d="M24.5 41C35.8218 41 45 31.8218 45 20.5C45 9.17816 35.8218 0 24.5 0C13.1782 0 4 9.17816 4 20.5C4 31.8218 13.1782 41 24.5 41Z" fill="#FFDD67"/>
                        <path d="M16.6413 18.7913C18.5282 18.7913 20.0579 17.2616 20.0579 15.3747C20.0579 13.4877 18.5282 11.958 16.6413 11.958C14.7543 11.958 13.2246 13.4877 13.2246 15.3747C13.2246 17.2616 14.7543 18.7913 16.6413 18.7913Z" fill="#6D6D6D"/>
                        <path d="M32.3581 18.7913C34.245 18.7913 35.7747 17.2616 35.7747 15.3747C35.7747 13.4877 34.245 11.958 32.3581 11.958C30.4711 11.958 28.9414 13.4877 28.9414 15.3747C28.9414 17.2616 30.4711 18.7913 32.3581 18.7913Z" fill="#6D6D6D"/>
                        <path d="M36.1161 24.5998C36.1161 24.0532 35.7745 23.3698 34.8861 23.1648C32.4945 22.6865 29.0095 22.2765 24.4995 22.2765C19.9895 22.2765 16.5045 22.7548 14.1128 23.1648C13.2245 23.3698 12.8828 24.0532 12.8828 24.5998C12.8828 29.5882 16.7095 34.5765 24.4995 34.5765C32.2895 34.5765 36.1161 29.5882 36.1161 24.5998Z" fill="#4F4F4F"/>
                        <path d="M33.1787 24.8053C31.6754 24.5319 28.5321 24.1219 24.5004 24.1219C20.4687 24.1219 17.3254 24.5319 15.8221 24.8053C14.9337 24.9419 14.8654 25.2836 14.9337 25.8303C15.0021 26.1036 15.0021 26.5136 15.1387 26.9236C15.2071 27.3336 15.3437 27.5386 16.0271 27.4703C17.3254 27.3336 31.7437 27.3336 33.0421 27.4703C33.7254 27.5386 33.7937 27.3336 33.9304 26.9236C33.9987 26.5136 34.0671 26.1719 34.1354 25.8303C34.1354 25.2836 34.0671 24.9419 33.1787 24.8053Z" fill="white"/>
                        </g>
                        <defs>
                        <filter id="filter0_d_844_709" x="0" y="0" width="49" height="49" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                        <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                        <feOffset dy="4"/>
                        <feGaussianBlur stdDeviation="2"/>
                        <feComposite in2="hardAlpha" operator="out"/>
                        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_844_709"/>
                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_844_709" result="shape"/>
                        </filter>
                        </defs>
                  </svg>
              </div>
            </>
          )}

          {num === 3 && (
            <>
              <div className="StickerItem_disable flex flexCenter alignCenter">
                {/* SVG #3 - Disabled */}
                <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                    <path d="M20.5 41C31.8218 41 41 31.8218 41 20.5C41 9.17816 31.8218 0 20.5 0C9.17816 0 0 9.17816 0 20.5C0 31.8218 9.17816 41 20.5 41Z" fill="#D1D1D1"/>
                    <path d="M12.6413 18.8588C14.5282 18.8588 16.0579 17.3292 16.0579 15.4422C16.0579 13.5552 14.5282 12.0255 12.6413 12.0255C10.7543 12.0255 9.22461 13.5552 9.22461 15.4422C9.22461 17.3292 10.7543 18.8588 12.6413 18.8588Z" fill="#6D6D6D"/>
                    <path d="M28.3581 18.8588C30.245 18.8588 31.7747 17.3292 31.7747 15.4422C31.7747 13.5552 30.245 12.0255 28.3581 12.0255C26.4711 12.0255 24.9414 13.5552 24.9414 15.4422C24.9414 17.3292 26.4711 18.8588 28.3581 18.8588Z" fill="#6D6D6D"/>
                    <path d="M31.5013 23.9159C28.5629 28.0842 25.0096 29.1092 20.4996 29.1092C15.9896 29.1092 12.4363 28.0842 9.49793 23.9159C9.08793 23.3692 7.9946 23.7109 8.26793 24.5309C9.8396 29.9976 15.1013 33.2092 20.5679 33.2092C26.0346 33.2092 31.2963 29.9976 32.8679 24.5309C33.0046 23.7109 31.9113 23.3692 31.5013 23.9159Z" fill="#4F4F4F"/>
                </svg>
              </div>
              <div className="StickerItem_enable flex flexCenter alignCenter">
               {/* SVG #3 - Active */}
                <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                    <path d="M20.5 41C31.8218 41 41 31.8218 41 20.5C41 9.17816 31.8218 0 20.5 0C9.17816 0 0 9.17816 0 20.5C0 31.8218 9.17816 41 20.5 41Z" fill="#FFDD67"/>
                    <path d="M12.6413 18.8588C14.5282 18.8588 16.0579 17.3292 16.0579 15.4422C16.0579 13.5552 14.5282 12.0255 12.6413 12.0255C10.7543 12.0255 9.22461 13.5552 9.22461 15.4422C9.22461 17.3292 10.7543 18.8588 12.6413 18.8588Z" fill="#6D6D6D"/>
                    <path d="M28.3581 18.8588C30.245 18.8588 31.7747 17.3292 31.7747 15.4422C31.7747 13.5552 30.245 12.0255 28.3581 12.0255C26.4711 12.0255 24.9414 13.5552 24.9414 15.4422C24.9414 17.3292 26.4711 18.8588 28.3581 18.8588Z" fill="#6D6D6D"/>
                    <path d="M31.5013 23.9159C28.5629 28.0842 25.0096 29.1092 20.4996 29.1092C15.9896 29.1092 12.4363 28.0842 9.49793 23.9159C9.08793 23.3692 7.9946 23.7109 8.26793 24.5309C9.8396 29.9976 15.1013 33.2092 20.5679 33.2092C26.0346 33.2092 31.2963 29.9976 32.8679 24.5309C33.0046 23.7109 31.9113 23.3692 31.5013 23.9159Z" fill="#4F4F4F"/>
                </svg>
              </div>
            </>
          )}

          {num === 4 && (
            <>
              <div className="StickerItem_disable flex flexCenter alignCenter">
               {/* SVG #4 - Disabled */}
                <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                    <path d="M20.5 41C31.8218 41 41 31.8218 41 20.5C41 9.17816 31.8218 0 20.5 0C9.17816 0 0 9.17816 0 20.5C0 31.8218 9.17816 41 20.5 41Z" fill="#D1D1D1"/>
                    <path d="M12.6432 20.2273C14.5302 20.2273 16.0599 18.6976 16.0599 16.8106C16.0599 14.9236 14.5302 13.3939 12.6432 13.3939C10.7563 13.3939 9.22656 14.9236 9.22656 16.8106C9.22656 18.6976 10.7563 20.2273 12.6432 20.2273Z" fill="#6D6D6D"/>
                    <path d="M28.36 20.2273C30.247 20.2273 31.7767 18.6976 31.7767 16.8106C31.7767 14.9236 30.247 13.3939 28.36 13.3939C26.4731 13.3939 24.9434 14.9236 24.9434 16.8106C24.9434 18.6976 26.4731 20.2273 28.36 20.2273Z" fill="#6D6D6D"/>
                    <path d="M14.3524 31.1626C18.3158 27.8826 22.6891 27.8826 26.6524 31.1626C27.1308 31.5726 27.5408 30.8893 27.1991 30.2743C25.9691 27.951 23.5774 25.8326 20.5024 25.8326C17.4274 25.8326 14.9674 27.951 13.8058 30.2743C13.4641 30.8893 13.8741 31.5726 14.3524 31.1626Z" fill="#4F4F4F"/>
                </svg>
              </div>
              <div className="StickerItem_enable flex flexCenter alignCenter">
               {/* SVG #4 - Active */}
                <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                    <g clipPath="url(#clip0_844_848)">
                    <path d="M20.5 41C31.8218 41 41 31.8218 41 20.5C41 9.17816 31.8218 0 20.5 0C9.17816 0 0 9.17816 0 20.5C0 31.8218 9.17816 41 20.5 41Z" fill="#FFDD67"/>
                    <path d="M12.6432 20.2273C14.5302 20.2273 16.0599 18.6976 16.0599 16.8106C16.0599 14.9236 14.5302 13.3939 12.6432 13.3939C10.7563 13.3939 9.22656 14.9236 9.22656 16.8106C9.22656 18.6976 10.7563 20.2273 12.6432 20.2273Z" fill="#6D6D6D"/>
                    <path d="M28.36 20.2273C30.247 20.2273 31.7767 18.6976 31.7767 16.8106C31.7767 14.9236 30.247 13.3939 28.36 13.3939C26.4731 13.3939 24.9434 14.9236 24.9434 16.8106C24.9434 18.6976 26.4731 20.2273 28.36 20.2273Z" fill="#6D6D6D"/>
                    <path d="M14.3524 31.1626C18.3158 27.8826 22.6891 27.8826 26.6524 31.1626C27.1308 31.5726 27.5408 30.8893 27.1991 30.2743C25.9691 27.951 23.5774 25.8326 20.5024 25.8326C17.4274 25.8326 14.9674 27.951 13.8058 30.2743C13.4641 30.8893 13.8741 31.5726 14.3524 31.1626Z" fill="#4F4F4F"/>
                    </g>
                    <defs>
                    <clipPath id="clip0_844_848">
                    <rect width="41" height="41" fill="white"/>
                    </clipPath>
                     </defs>
                </svg>
              </div>
            </>
          )}

          {num === 5 && (
            <>
              <div className="StickerItem_disable flex flexCenter alignCenter">
                {/* SVG #5 - Disabled */}
                <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                   <path d="M0 20.5C0 31.8433 9.15667 41 20.5 41C31.8433 41 41 31.8433 41 20.5C41 9.15667 31.8433 0 20.5 0C9.15667 0 0 9.15667 0 20.5Z" fill="#D1D1D1"/>
                   <path d="M27.0586 27.8366C27.0586 30.0813 30.3386 30.0813 30.3386 27.8366C30.3386 26.1922 28.7126 24.6001 28.7126 24.6001C28.7126 24.6001 27.0586 26.1922 27.0586 27.8366Z" fill="white"/>
                   <path d="M28.153 23.2335C30.04 23.2335 31.5697 21.7038 31.5697 19.8168C31.5697 17.9298 30.04 16.4001 28.153 16.4001C26.266 16.4001 24.7363 17.9298 24.7363 19.8168C24.7363 21.7038 26.266 23.2335 28.153 23.2335Z" fill="#6D6D6D"/>
                   <path d="M12.4362 23.2335C14.3232 23.2335 15.8529 21.7038 15.8529 19.8168C15.8529 17.9298 14.3232 16.4001 12.4362 16.4001C10.5492 16.4001 9.01953 17.9298 9.01953 19.8168C9.01953 21.7038 10.5492 23.2335 12.4362 23.2335Z" fill="#6D6D6D"/>
                   <path d="M15.8823 9.13176C13.6957 10.9768 10.7573 11.7968 7.88734 11.2501C7.47734 11.1818 7.13567 12.6168 7.614 12.7534C10.894 13.3684 14.3107 12.4118 16.839 10.2934C17.1807 9.95176 16.1557 8.85843 15.8823 9.13176ZM32.624 11.1818C29.754 11.6601 26.8157 10.9084 24.629 9.06343C24.3557 8.7901 23.2623 9.88343 23.6723 10.2251C26.2007 12.4118 29.6173 13.3001 32.8973 12.6851C33.3757 12.5484 33.034 11.1134 32.624 11.1818Z" fill="#6D6D6D"/>
                   <path d="M25.6314 33.1644C22.0979 31.0972 17.8169 30.6647 13.9618 31.9866C13.0051 32.3546 13.9394 34.8213 14.8774 34.5191C17.4099 33.6035 21.108 33.5866 24.3314 35.4949C25.1301 35.9344 26.5243 33.7727 25.6314 33.1644Z" fill="#4F4F4F"/>
                </svg>
              </div>
              <div className="StickerItem_enable flex flexCenter alignCenter">
               {/* SVG #5 - Active */}
                <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                    <path d="M0 20.5C0 31.8433 9.15667 41 20.5 41C31.8433 41 41 31.8433 41 20.5C41 9.15667 31.8433 0 20.5 0C9.15667 0 0 9.15667 0 20.5Z" fill="#FFDD67"/>
                    <path d="M27.0586 27.8366C27.0586 30.0813 30.3386 30.0813 30.3386 27.8366C30.3386 26.1922 28.7126 24.6001 28.7126 24.6001C28.7126 24.6001 27.0586 26.1922 27.0586 27.8366Z" fill="#65B1EF"/>
                    <path d="M28.153 23.2335C30.04 23.2335 31.5697 21.7038 31.5697 19.8168C31.5697 17.9298 30.04 16.4001 28.153 16.4001C26.266 16.4001 24.7363 17.9298 24.7363 19.8168C24.7363 21.7038 26.266 23.2335 28.153 23.2335Z" fill="#6D6D6D"/>
                    <path d="M12.4362 23.2335C14.3232 23.2335 15.8529 21.7038 15.8529 19.8168C15.8529 17.9298 14.3232 16.4001 12.4362 16.4001C10.5492 16.4001 9.01953 17.9298 9.01953 19.8168C9.01953 21.7038 10.5492 23.2335 12.4362 23.2335Z" fill="#6D6D6D"/>
                    <path d="M15.8823 9.13176C13.6957 10.9768 10.7573 11.7968 7.88734 11.2501C7.47734 11.1818 7.13567 12.6168 7.614 12.7534C10.894 13.3684 14.3107 12.4118 16.839 10.2934C17.1807 9.95176 16.1557 8.85843 15.8823 9.13176ZM32.624 11.1818C29.754 11.6601 26.8157 10.9084 24.629 9.06343C24.3557 8.7901 23.2623 9.88343 23.6723 10.2251C26.2007 12.4118 29.6173 13.3001 32.8973 12.6851C33.3757 12.5484 33.034 11.1134 32.624 11.1818Z" fill="#6D6D6D"/>
                    <path d="M25.6314 33.1644C22.0979 31.0972 17.8169 30.6647 13.9618 31.9866C13.0051 32.3546 13.9394 34.8213 14.8774 34.5191C17.4099 33.6035 21.108 33.5866 24.3314 35.4949C25.1301 35.9344 26.5243 33.7727 25.6314 33.1644Z" fill="#4F4F4F"/>
                </svg>
              </div>
            </>
          )}
        </figure>
      </div>
    </li>
  ))}
</ul>


</li>


            <li className="descLi w100">
              <label htmlFor="description">
                نظر خود را درباره این وبلاگ بنویسید
              </label>
              <textarea
                id="description"
                className="txtarea radius14 borderLightGray w100"
                placeholder="توضیحات..."
                rows={4}
                required
              />
            </li>

            <li className="w100">
              <button
                type="submit"
                className="addBtn bgGreen radius40 flex flexCenter alignCenter whiteTxt animationGreenBox w100"
              >
                ارسال دیدگاه
              </button>
            </li>
          </ul>
        </form>
      </div>
    </section>
  );
}
