"use client";

import NewsList from "../components/NewsList";
import InnerTitle from "@/app/components/common/InnerTitle";
import CategorySlider from "@/app/components/common/CategorySlider";

interface NewestBlogProps {
  items: {
    id?: number;
    title: string;
    slug: string;
    image: string;
    date: string;
    readTime: string;
    summary?: string | null;
  }[];
  categories: {
    title: string;
    slug: string;
  }[];
}

export default function NewestBlog({ items, categories }: NewestBlogProps) {
  // 🔥 Category slider data mapper
  const mappedCategories = categories.map((cat, index) => ({
    id: index + 1,
    label: cat.title,
    slug: cat.slug,
  }));

  // 🔥 NewsList items mapper
  const mappedItems = items.map((item, index) => ({
    id: index + 1,
    title: item.title,
    slug: item.slug,
    image: item.image,
    date: item.date,
    readTime: item.readTime,
    desc: item.summary || "",
  }));

  const selectedCategory = "";

  return (
    <section className="TheLatestBlogs">
      <InnerTitle first="جدیدترین" second="مقالات و رویداد‌ها" />

      {/* Category Slider */}
      <CategorySlider
        categories={mappedCategories}
        basePath="/news/list"
        selectedCategory={selectedCategory}
        mode="link"
      />

      {/* News List */}
      <NewsList articles={mappedItems} />
    </section>
  );
}
