import { FC } from "react";

interface NewsHeaderProps {
  title: string;
  date: string;
}

const NewsHeader: FC<NewsHeaderProps> = ({ title, date }) => {
  return (
    <section className="blogDetailPage_head flex flexSpace alignCenter">
     {/* --- News title (H1 for SEO) --- */}
      <div className="blogDetailPage_head_r blueTxt">
        <h1>{title}</h1>
      </div>

     {/* --- News date --- */}
      <div className="blogDetailPage_head_l flex flexEnd alignCenter">
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="24"
          height="24"
          viewBox="0 0 24 24"
          fill="none"
        >
          <path
            d="M3.09375 9.40625H20.9177"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M16.4375 13.3125H16.4468"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M12 13.3125H12.0093"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M7.5625 13.3125H7.57176"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M16.4375 17.1953H16.4468"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M12 17.1953H12.0093"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M7.5625 17.1953H7.57176"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M16.0469 2V5.29078"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            d="M7.96875 2V5.29078"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16.2383 3.57812H7.77096C4.83427 3.57812 3 5.21406 3 8.22115V17.2708C3 20.3252 4.83427 21.9989 7.77096 21.9989H16.229C19.175 21.9989 21 20.3535 21 17.3464V8.22115C21.0092 5.21406 19.1842 3.57812 16.2383 3.57812Z"
            stroke="#888888"
            strokeWidth="1.125"
            strokeLinecap="round"
            strokeLinejoin="round"
          />
        </svg>
        <time dateTime={date}>{date}</time>
      </div>
    </section>
  );
};

export default NewsHeader;
