import Image from "next/image";
import Link from "next/link";
import { NewsListModel } from "@/src/types/news";
export default function NewsListItem({ item }: { item: NewsListModel }) {
  return (
    <li key={item.id}>
      <Link
        href={item.slug ? `/news/${item.slug}` : "#"}
        className="newsList_item radius16 flex flexSpace border-lightGreen"
      >
        <figure className="blogItem_img w100 radius12 overflow hoverImg">
          <Image
            src={item.image}
            alt={item.title}
            width={200}
            height={200}
            className="objectfitCover"
          />
        </figure>

        <figcaption className="blogItemTxt w100">
          <div className="newsTitle darkTxt">
            <strong>{item.title}</strong>
          </div>

          <div className="desc">
            <p>{item.desc}</p>
          </div>

          <div className="date flex flexSpace alignCenter">
            <div className="date_r flex flexStart alignCenter">
              <time className="time">{item.date}</time>
            </div>
            <div className="date_l flex flexStart alignCenter">
              <span className="time">{item.readTime}</span>
            </div>
          </div>
        </figcaption>
      </Link>
    </li>
  );
}


