import { FC } from "react";

interface NewsMetaProps {
  readTime: string; 
  rating: number; 
  commentsCount: number;
}

const NewsMeta: FC<NewsMetaProps> = ({
  readTime = "1 دقیقه زمان مطالعه",
  rating = 4.9,
  commentsCount = 0,
}) => {
  return (
    <section className="score flex flexStart alignCenter">
      {/* --- Study time --- */}
      <div className="time flex flexStart alignCenter">
        <div className="IconItem flex flexCenter alignCenter">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="24"
            height="25"
            viewBox="0 0 24 25"
            fill="none"
          >
            <path
              d="M12 22.5795C11.7 22.5795 11.4 22.5095 11.15 22.3695C9.28 21.3495 5.99 20.2695 3.93 19.9995L3.64 19.9595C2.33 19.7995 1.25 18.5695 1.25 17.2395V5.15952C1.25 4.36952 1.56 3.64952 2.13 3.12952C2.7 2.60952 3.44 2.35952 4.22 2.42952C6.42 2.59952 9.74 3.69952 11.62 4.87952L11.86 5.01952C11.93 5.05952 12.08 5.05952 12.14 5.02952L12.3 4.92952C14.18 3.74952 17.5 2.62952 19.71 2.43952C19.73 2.43952 19.81 2.43952 19.83 2.43952C20.56 2.36952 21.31 2.62952 21.87 3.14952C22.44 3.66952 22.75 4.38952 22.75 5.17952V17.2495C22.75 18.5895 21.67 19.8095 20.35 19.9695L20.02 20.0095C17.96 20.2795 14.66 21.3695 12.83 22.3795C12.59 22.5195 12.3 22.5795 12 22.5795ZM3.98 3.91952C3.66 3.91952 3.37 4.02952 3.14 4.23952C2.89 4.46952 2.75 4.79952 2.75 5.15952V17.2395C2.75 17.8295 3.26 18.3995 3.83 18.4795L4.13 18.5195C6.38 18.8195 9.83 19.9495 11.83 21.0395C11.92 21.0795 12.05 21.0895 12.1 21.0695C14.1 19.9595 17.57 18.8195 19.83 18.5195L20.17 18.4795C20.74 18.4095 21.25 17.8295 21.25 17.2395V5.16952C21.25 4.79952 21.11 4.47952 20.86 4.23952C20.6 4.00952 20.27 3.89952 19.9 3.91952C19.88 3.91952 19.8 3.91952 19.78 3.91952C17.87 4.08952 14.79 5.11952 13.11 6.16952L12.95 6.27952C12.4 6.61952 11.62 6.61952 11.09 6.28952L10.85 6.14952C9.14 5.09952 6.06 4.07952 4.1 3.91952C4.06 3.91952 4.02 3.91952 3.98 3.91952Z"
              fill="#888888"
            />
            <path
              d="M12 21.74C11.59 21.74 11.25 21.4 11.25 20.99V5.98999C11.25 5.57999 11.59 5.23999 12 5.23999C12.41 5.23999 12.75 5.57999 12.75 5.98999V20.99C12.75 21.41 12.41 21.74 12 21.74Z"
              fill="#888888"
            />
            <path
              d="M7.75 9.73999H5.5C5.09 9.73999 4.75 9.39999 4.75 8.98999C4.75 8.57999 5.09 8.23999 5.5 8.23999H7.75C8.16 8.23999 8.5 8.57999 8.5 8.98999C8.5 9.39999 8.16 9.73999 7.75 9.73999Z"
              fill="#888888"
            />
            <path
              d="M8.5 12.74H5.5C5.09 12.74 4.75 12.4 4.75 11.99C4.75 11.58 5.09 11.24 5.5 11.24H8.5C8.91 11.24 9.25 11.58 9.25 11.99C9.25 12.4 8.91 12.74 8.5 12.74Z"
              fill="#888888"
            />
          </svg>
        </div>
        <div className="studyTime">
          <span>{readTime}</span>
        </div>
      </div>

     {/* --- User ratings and comments --- */}
      <div className="scoring flex flexStart alignCenter">
        <div className="IconItem flex flexCenter alignCenter">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="20"
            height="19"
            viewBox="0 0 20 19"
            fill="none"
          >
            <path
              d="M10 15.27L16.18 19L14.54 11.97L20 7.24L12.81 6.63L10 0L7.19 6.63L0 7.24L5.46 11.97L3.82 19L10 15.27Z"
              fill="#FFDD00"
            />
          </svg>
          <label>{rating.toFixed(1)}</label>
        </div>

        <div className="commentLbl flex flexEnd alignCenter">
          <span>نظرات کاربران</span>
          <label className="blueTxt">{commentsCount} نظر</label>
        </div>
      </div>
    </section>
  );
};

export default NewsMeta;
