"use client";

import Link from "next/link";
import { NewsTopItem } from "../types/newsTop";

interface NewsTopProps {
  items: NewsTopItem[];
}

export default function NewsTop({ items }: NewsTopProps) {

  const [first, second, third, fourth] = items;

  return (
    <section className="blogPage_top flex flexSpace">
      <div className="blogPage_top_r">
        <div className="blogPage_top_r_up flex flexSpace">
          {[first, second].map(
            (item) =>
              item && (
                <Link
                  key={item.id}
                  className="blogItem radius24 overflow hoverBoxShadow w49"
                  href={`/news/${item.slug}`}
                >
                  <figure className="blogItem_img relative w100">
                    <img
                      className="w100 h100 objectfitCover"
                      src={item.image}
                      alt={item.title}
                    />
                  </figure>
                  <figcaption className="blogItem_txt absolute w100 z-index">
                    <div className="blogItem_title whiteTxt">
                      <h2>{item.title}</h2>
                    </div>
                    <div className="date flex flexSpace alignCenter">
                      <div className="date_r flex flexStart alignCenter">
                        <div className="IconItem flex flexCenter alignCenter">
                          {/* SVG تقویم */}
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="14"
                            height="16"
                            viewBox="0 0 14 16"
                            fill="none"
                          >
                            <path
                              d="M1.0625 6.27084H12.9451"
                              stroke="#05C7BB"
                              strokeWidth="1.125"
                              strokeLinecap="round"
                              strokeLinejoin="round"
                            />
                            <path
                              d="M9.9585 8.875H9.96467"
                              stroke="#05C7BB"
                              strokeWidth="1.125"
                              strokeLinecap="round"
                              strokeLinejoin="round"
                            />
                            <path
                              d="M7 8.875H7.00618"
                              stroke="#05C7BB"
                              strokeWidth="1.125"
                              strokeLinecap="round"
                              strokeLinejoin="round"
                            />
                            <path
                              d="M4.0415 8.875H4.04768"
                              stroke="#05C7BB"
                              strokeWidth="1.125"
                              strokeLinecap="round"
                              strokeLinejoin="round"
                            />
                          </svg>
                        </div>
                        <time className="time">{item.date}</time>
                      </div>
                      <div className="date_l flex flexEnd alignCenter">
                        <div className="IconItem flex flexCenter alignCenter">
                          {/* SVG */}
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="16"
                            height="16"
                            viewBox="0 0 16 16"
                            fill="none"
                          >
                            <path
                              d="M8 14.16C7.72667 14.16 7.5 13.9333 7.5 13.66V3.66C7.5 3.38667 7.72667 3.16 8 3.16C8.27333 3.16 8.5 3.38667 8.5 3.66V13.66C8.5 13.94 8.27333 14.16 8 14.16Z"
                              fill="#05C7BB"
                            />
                          </svg>
                        </div>
                        <div className="time">
                          <span>{item.read}</span>
                        </div>
                      </div>
                    </div>
                  </figcaption>
                </Link>
              )
          )}
        </div>

        <div className="blogPage_top_r_down">
          {third && (
            <Link
              className="blogItem radius24 overflow hoverBoxShadow"
              href={`/news/${third.slug}`}
            >
              <figure className="blogItem_img relative w100">
                <img
                  className="w100 h100 objectfitCover"
                  src={third.image}
                  alt={third.title}
                />
              </figure>
              <figcaption className="blogItem_txt absolute w100 z-index">
                <div className="blogItem_title whiteTxt">
                  <h2>{third.title}</h2>
                </div>
                <div className="date flex flexSpace alignCenter">
                  <div className="date_r flex flexStart alignCenter">
                    <time className="time">{third.date}</time>
                  </div>
                  <div className="date_l flex flexEnd alignCenter">
                    <span className="time">{third.read}</span>
                  </div>
                </div>
              </figcaption>
            </Link>
          )}
        </div>
      </div>

      <div className="blogPage_top_l">
        {fourth && (
          <Link
            className="blogItem radius24 overflow hoverBoxShadow"
            href={`/news/${fourth.slug}`}
          >
            <figure className="blogItem_img relative w100">
              <img
                className="w100 h100 objectfitCover"
                src={fourth.image}
                alt={fourth.title}
              />
            </figure>
            <figcaption className="blogItem_txt absolute w100 z-index">
              <div className="blogItem_title whiteTxt">
                <h2>{fourth.title}</h2>
              </div>
              <div className="date flex flexSpace alignCenter">
                <div className="date_r flex flexStart alignCenter">
                  <time className="time">{fourth.date}</time>
                </div>
                <div className="date_l flex flexEnd alignCenter">
                  <span className="time">{fourth.read}</span>
                </div>
              </div>
            </figcaption>
          </Link>
        )}
      </div>
    </section>
  );
}
