import Image from "next/image";

interface NewsTopImageProps {
  image: string;
  title: string;
}

export default function NewsTopImage({ image, title }: NewsTopImageProps) {
  return (
    <section className="topImg relative">
      <figure className="radius20 relative">
        <Image
          src={image}
          alt={title}
          fill
          priority
          className="radius20 w100 h100 objectfitCover"
        />
      </figure>
    </section>
  );
}
