"use client";

import Image from "next/image";
import Link from "next/link";
import InnerTitle from "@/app/components/common/InnerTitle";
import type { PopularNewsProps } from "../types/popularNews";

export default function PopularNews({ main, list }: PopularNewsProps) {

  if (!main) return null;

  return (
    <section className="mostPopularBlogs">
      <InnerTitle first="محبوب‌ترین" second="مقالات و رویداد‌ها" />

      <div className="mostPopularBlogs_List flex flexSpace">

       {/* --- Main news --- */}
        <div className="mostPopularBlogs_List_r">
          <Link
            href={`/news/${encodeURIComponent(main.slug)}`}
            className="blogItem radius24 overflow"
          >
            <figure className="blogItem_img relative w100">
              <Image
                src={main.image}
                alt={main.title}
                fill
                className="objectfitCover"
              />
            </figure>
            <figcaption className="blogItem_txt absolute w100 z-index">
              <div className="blogItem_title whiteTxt">
                <h2>{main.title}</h2>
              </div>
              <div className="date flex flexSpace alignCenter">
                <div className="date_r flex flexStart alignCenter">
                  <time className="time">{main.date}</time>
                </div>
                <div className="date_l flex flexEnd alignCenter">
                  <span className="time">{main.readTime}</span>
                </div>
              </div>
            </figcaption>
          </Link>
        </div>

        <div className="newsList">
          <ul>
            {list.map((item) => (
              <li key={item.id}>
                <Link
                  href={`/news/${encodeURIComponent(item.slug)}`}
                  className="newsList_item radius16 flex flexSpace border-lightGreen"
                >
                  <figure className="blogItem_img w100 radius12 overflow hoverImg">
                    <Image
                      src={item.image}
                      alt={item.title}
                      width={200}
                      height={200}
                      className="objectfitCover"
                    />
                  </figure>
                  <figcaption className="blogItemTxt w100">
                    <div className="newsTitle darkTxt">
                      <strong>{item.title}</strong>
                    </div>
                    <div className="desc">
                      <p>{item.desc}</p>
                    </div>
                    <div className="date flex flexSpace alignCenter">
                      <div className="date_r flex flexStart alignCenter">
                        <time className="time">{item.date}</time>
                      </div>
                      <div className="date_l flex flexStart alignCenter">
                        <span className="time">{item.readTime}</span>
                      </div>
                    </div>
                  </figcaption>
                </Link>
              </li>
            ))}
          </ul>
        </div>

      </div>
    </section>
  );
}
