import Link from "next/link";

interface RelatedNewsItem {
  id?: number;
  slug: string;
  title: string;
  excerpt?: string;
  image: string;
  date: string;
  readTime?: string;
}

interface RelatedNewsProps {
  related: RelatedNewsItem[];
}

export default function RelatedNews({ related }: RelatedNewsProps) {
  return (
    <section className="RelatedBlogs">
      {/* --- Title --- */}
      <div className="pulicInnerTitle relative">
        <strong>
          <span className="txtDark fontBold">مقالات و رویدادهای</span>
          <label className="blueTxt">مرتبط</label>
        </strong>
      </div>

     {/* --- List of articles --- */}
      <div className="newsList">
        <ul>
          {related.map((item) => (
            <li key={item.id}>
              <Link
                href={`/news/${item.slug}`}
                className="newsList_item radius16 flex flexSpace border-lightGreen"
              >
                <figure className="blogItem_img w100 radius12 overflow hoverImg">
                  <img
                    src={item.image}
                    alt={item.title}
                    className="w100 h100 objectfitCover"
                  />
                </figure>

                <figcaption className="blogItemTxt w100">
                  <div className="newsTitle darkTxt">
                    <strong>{item.title}</strong>
                  </div>

                  <div className="desc">
                    <p>{item.excerpt}</p>
                  </div>

                  <div className="date flex flexSpace alignCenter">
                    <div className="date_r flex flexStart alignCenter">
                      <div className="IconItem flex flexCenter alignCenter">
                        {/* Calendar icon */}
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="16" viewBox="0 0 14 16" fill="none">
                                                            <path d="M1.0625 6.27084H12.9451" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M9.9585 8.875H9.96467" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M7 8.875H7.00618" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M4.0415 8.875H4.04768" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M9.9585 11.4636H9.96467" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M7 11.4636H7.00618" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M4.0415 11.4636H4.04768" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M9.69775 1.33334V3.5272" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path d="M4.3125 1.33334V3.5272" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                                                            <path fillRule="evenodd" clipRule="evenodd" d="M9.82551 2.38544H4.18064C2.22285 2.38544 1 3.47606 1 5.48079V11.5139C1 13.5501 2.22285 14.666 4.18064 14.666H9.81933C11.7833 14.666 13 13.569 13 11.5643V5.48079C13.0062 3.47606 11.7895 2.38544 9.82551 2.38544Z" stroke="#05C7BB" strokeWidth="1.125" strokeLinecap="round" strokeLinejoin="round"></path>
                        </svg>
                      </div>
                      <time className="time">{item.date}</time>
                    </div>

                    <div className="date_l flex flexStart alignCenter">
                      <div className="IconItem flex flexCenter alignCenter">
                        {/* Clock icon */}
                       <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                          <path d="M8.00016 14.7197C7.80016 14.7197 7.60016 14.673 7.4335 14.5797C6.18683 13.8997 3.9935 13.1797 2.62016 12.9997L2.42683 12.973C1.5535 12.8664 0.833496 12.0464 0.833496 11.1597V3.10636C0.833496 2.57969 1.04016 2.09969 1.42016 1.75302C1.80016 1.40636 2.2935 1.23969 2.8135 1.28636C4.28016 1.39969 6.4935 2.13302 7.74683 2.91969L7.90683 3.01302C7.9535 3.03969 8.0535 3.03969 8.0935 3.01969L8.20016 2.95302C9.4535 2.16636 11.6668 1.41969 13.1402 1.29302C13.1535 1.29302 13.2068 1.29302 13.2202 1.29302C13.7068 1.24636 14.2068 1.41969 14.5802 1.76636C14.9602 2.11302 15.1668 2.59302 15.1668 3.11969V11.1664C15.1668 12.0597 14.4468 12.873 13.5668 12.9797L13.3468 13.0064C11.9735 13.1864 9.7735 13.913 8.5535 14.5864C8.3935 14.6797 8.20016 14.7197 8.00016 14.7197ZM2.6535 2.27969C2.44016 2.27969 2.24683 2.35302 2.0935 2.49302C1.92683 2.64636 1.8335 2.86636 1.8335 3.10636V11.1597C1.8335 11.553 2.1735 11.933 2.5535 11.9864L2.7535 12.013C4.2535 12.213 6.5535 12.9664 7.88683 13.693C7.94683 13.7197 8.0335 13.7264 8.06683 13.713C9.40016 12.973 11.7135 12.213 13.2202 12.013L13.4468 11.9864C13.8268 11.9397 14.1668 11.553 14.1668 11.1597V3.11302C14.1668 2.86636 14.0735 2.65302 13.9068 2.49302C13.7335 2.33969 13.5135 2.26636 13.2668 2.27969C13.2535 2.27969 13.2002 2.27969 13.1868 2.27969C11.9135 2.39302 9.86016 3.07969 8.74016 3.77969L8.6335 3.85302C8.26683 4.07969 7.74683 4.07969 7.3935 3.85969L7.2335 3.76636C6.0935 3.06636 4.04016 2.38636 2.7335 2.27969C2.70683 2.27969 2.68016 2.27969 2.6535 2.27969Z" fill="#05C7BB"></path>
                          <path d="M8 14.16C7.72667 14.16 7.5 13.9333 7.5 13.66V3.66C7.5 3.38667 7.72667 3.16 8 3.16C8.27333 3.16 8.5 3.38667 8.5 3.66V13.66C8.5 13.94 8.27333 14.16 8 14.16Z" fill="#05C7BB"></path>
                          <path d="M5.1665 6.16H3.6665C3.39317 6.16 3.1665 5.93334 3.1665 5.66C3.1665 5.38667 3.39317 5.16 3.6665 5.16H5.1665C5.43984 5.16 5.6665 5.38667 5.6665 5.66C5.6665 5.93334 5.43984 6.16 5.1665 6.16Z" fill="#05C7BB"></path>
                          <path d="M5.6665 8.16H3.6665C3.39317 8.16 3.1665 7.93334 3.1665 7.66C3.1665 7.38667 3.39317 7.16 3.6665 7.16H5.6665C5.93984 7.16 6.1665 7.38667 6.1665 7.66C6.1665 7.93334 5.93984 8.16 5.6665 8.16Z" fill="#05C7BB"></path>
                        </svg>
                      </div>
                      <div className="time">
                        <span>{item.readTime}</span>
                      </div>
                    </div>
                  </div>
                </figcaption>
              </Link>
            </li>
          ))}
        </ul>
      </div>
    </section>
  );
}
