"use client";
import { usePathname } from "next/navigation";

export default function ShareButtons({ title }: { title: string }) {
  const pathname = usePathname();
  const url =
    typeof window !== "undefined"
      ? window.location.origin + pathname
      : pathname;

  return (
    <div className="shareBox flex flexStart alignCenter">
      <span className="shareBox_title">اشتراک‌گذاری:</span>
      <ul className="shareBox_list flex flexStart alignCenter">
        <li>
          <a
            className="shareBtn radius8"
            href={`https://t.me/share/url?url=${encodeURIComponent(url)}&text=${encodeURIComponent(title)}`}
            target="_blank"
            rel="noopener nofollow"
          >
            تلگرام
          </a>
        </li>
        <li>
          <a
            className="shareBtn radius8"
            href={`https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`}
            target="_blank"
            rel="noopener nofollow"
          >
            لینکدین
          </a>
        </li>
        <li>
          <button
            className="shareBtn radius8"
            onClick={() => {
              if (navigator.share) navigator.share({ title, url });
            }}
          >
            Web Share
          </button>
        </li>
      </ul>
    </div>
  );
}
