import type { NewsDetail } from "../types/newsDetail";
 
export const newsDetailsData: Record<string, NewsDetail> = {
  "اورژانس": {
    id: 1,
    slug: "اورژانس",
    title: "کم‌شنوایی ناشی از سر و صدا",
    excerpt:
      "مروری بر علل و پیشگیری از کم‌شنوایی ناشی از مواجهه با سر و صدا در محیط‌های درمانی و صنعتی.",
    contentHtml: `
      <!-- اینجا HTML خام بدنه مقاله‌ی تو قرار می‌گیره (همون فایلی که گفتی میفرستی) -->
      <div class="blogSingle_content">
        <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ...</p>
        <h2>تیتر داخلی نمونه</h2>
        <p>متن بدنه مقاله ...</p>
        <figure class="cmsImg relative w100">
          <img src="/images/newsImgLittle.png" alt="کم‌شنوایی ناشی از سر و صدا" class="w100 h100 objectfitCover" />
        </figure>
      </div>
    `,
    image: "/images/topArticle.png",
    date: "16 اسفند 1403",
    isoDate: "2025-03-06T08:00:00+03:30",
    readTime: "1 دقیقه زمان مطالعه",
    author: { name: "واحد روابط عمومی بیمارستان رضوی" },
    category: "اورژانس",
    tags: ["اورژانس", "سلامت شنوایی", "پیشگیری"],
    related: [
      {
        slug: "پرستاری",
        title: "تأثیر فولاد بر ساخت و ساز مدرن",
        image: "/images/newsImgLittle.png",
        date: "10 اسفند 1403",
      },
    ],
  },

  "پرستاری": {
    id: 2,
    slug: "پرستاری",
    title: "تأثیر فولاد بر ساخت و ساز مدرن",
    excerpt:
      "تحلیلی کوتاه از نقش فولاد در پروژه‌های عمرانی و استانداردهای ساخت‌وساز مدرن.",
    contentHtml: `
      <div class="blogSingle_content">
        <p>در این مقاله بررسی می‌کنیم چگونه تغییرات بازار فولاد ...</p>
      </div>
    `,
    image: "/images/topArticle.png",
    date: "10 اسفند 1403",
    isoDate: "2025-03-04T08:00:00+03:30",
    readTime: "2 دقیقه زمان مطالعه",
    author: { name: "مرکز پژوهش بیمارستان رضوی" },
    category: "پرستاری",
    tags: ["پرستاری", "فناوری ساخت", "ایمنی"],
    related: [
      {
        slug: "اورژانس",
        title: "کم‌شنوایی ناشی از سر و صدا",
        image: "/images/newsImgLittle.png",
        date: "16 اسفند 1403",
      },
    ],
  },
};
