// app/(sections)/blog/page.tsx

import { getNewsPage } from "@/src/lib/newsApi";
import { notFound } from "next/navigation";
import NewsTop from "./components/NewsTop";
import PopularNews from "./components/PopularNews";
import NewestBlog from "./components/NewestBlog";

export async function generateMetadata() {
  const data = await getNewsPage();
  if (!data) return {};

  const info = data.pageInfo;

  return {
    title: info.pageTitle || info.title || "اخبار",
    description: info.pageDescription || "",
    alternates: {
      canonical: info.canonical,
    },
    robots: info.pageRobotsStatus,
    openGraph: {
      title: info.ogTitle || info.pageTitle,
      description: info.ogDescription || info.pageDescription,
      images: info.ogImage ? [info.ogImage] : [],
      url: info.canonical,
      type: "website",
    },
  };
}

export default async function BlogPage() {
  const data = await getNewsPage();
  if (!data) return notFound();

  return (
    <div className="blogPage">
      <div className="mainSmall">

        {/* --- Top News (most viewers) --- */}
        <NewsTop
          items={data.mostViewersSection.map((item, index) => ({
            id: index + 1,
            title: item.title,
            slug: item.slug,
            image: item.picture,
            date: item.publishedDate,
            read: item.timeStudy,
          }))}
        />

        {/* --- Popular --- */}
        <PopularNews
          main={
            data.popularSection[0]
              ? {
                  id: 1,
                  title: data.popularSection[0].title,
                  slug: data.popularSection[0].slug,
                  image: data.popularSection[0].picture,
                  date: data.popularSection[0].publishedDate,
                  readTime: data.popularSection[0].timeStudy,
                  desc: data.popularSection[0].summary ?? "",
                }
              : null
          }
          list={data.popularSection.slice(1).map((item, index) => ({
            id: index + 2,
            title: item.title,
            slug: item.slug,
            image: item.picture,
            date: item.publishedDate,
            readTime: item.timeStudy,
            desc: item.summary ?? "",
          }))}
        />

       {/* --- Newest --- */}
<NewestBlog
  items={data.newestSection.newest.map((item, index) => ({
    id: index + 1,
    title: item.title,
    slug: item.slug,
    image: item.picture,
    date: item.publishedDate,
    readTime: item.timeStudy,
    desc: item.summary ?? "",
  }))}
  categories={data.newestSection.categories}
/>

      </div>
    </div>
  );
}
