"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";

import { ScientificEventData } from "../types/scientificEvents";

export default function ScientificEventsTabContent({ tab }: { tab: ScientificEventData }) {
  return (
    <div className="w100">
      {/* years Slider */}
      {tab.yearSlider.length > 0 && (
        <div className="w100 scientificEvents-history_slider flex flexSpace alignCenter">
          <Swiper
            modules={[Navigation]}
            slidesPerView={8}
            spaceBetween={10}
            navigation={{
              nextEl: ".scientificEventsSlider-next",
              prevEl: ".scientificEventsSlider-prev",
            }}
            className="scientificEventsSlider"
          >
            {tab.yearSlider.map((year) => (
              <SwiperSlide key={year}>
                <a
                  href="#"
                  className="scientificEventsSlider_item lightGrayBg flex flexCenter alignCenter radius12 relative"
                >
                  {year}
                </a>
              </SwiperSlide>
            ))}
          </Swiper>

          <div className="navBtn flex flexEnd alignCenter">
            <div className="publicBtn radius14 flex flexCenter alignCenter scientificEventsSlider-prev"> 
              <i className="fa-light fa-chevron-right"></i>
            </div>
            <div className="publicBtn radius14 flex flexCenter alignCenter scientificEventsSlider-next"> 
              <i className="fa-light fa-angle-left"></i>
            </div>
          </div>
        </div>
      )}

      {/* Image + Title */}
      <div className="frameLoading w100">
        <div className="scientificEvents-history_img radius16 overflow relative">
          <figure className="w100 h100">
            <img src={tab.image} alt={tab.title} className="w100 h100 objectfitCover" />
          </figure>
          <figcaption className="scientificEvents-history_title absolute z-index">
            <h2>{tab.title}</h2>
            <span>{tab.subtitle}</span>
          </figcaption>
        </div>

       {/* List of events */}
        <div className="scientificEvents-history_list radius16">
          <ul>
            {tab.events.map((event, i) => (
              <li key={i}>
                <div className="scientificEvents-history_list_item lightGrayBg radius16 flex flexSpace alignCenter">
                  <div className="scientificEvents-history_list_item_col">
                    <span>{event.titleFa}</span>
                  </div>
                  <div className="scientificEvents-history_list_item_col">
                    <span>{event.dateFa}</span>
                  </div>
                  <div className="scientificEvents-history_list_item_col">
                    <span>{event.titleEn}</span>
                  </div>
                </div>
              </li>
            ))}
          </ul>
        </div>
      </div>
    </div>
  );
}
