"use client";

import Tabs from "@/app/components/common/Tabs";
import TitlePage from "@/app/components/common/TitlePage";
import { scientificEventsTabs } from "./data/tabsData";
import ScientificEventsTabContent from "./components/ScientificEventsTabContent";

export default function ScientificEventsPage() {
  return (
    <div className="scientificEventsPage">
      <div className="mainSmall">
        <TitlePage title="رویدادهای علمی" />
        <section className="scientificEvents-history flex flexSpace alignStart">
          <Tabs
            tabs={scientificEventsTabs.map((tab) => ({
              id: tab.id,
              label: tab.label,
              content: <ScientificEventsTabContent tab={tab} />,
            }))}
          />
        </section>
      </div>
    </div>
  );
}
