"use client";

import { useSearchParams } from "next/navigation";
import TitlePage from "@/app/components/common/TitlePage";
import CategorySlider from "@/app/components/common/CategorySlider";
import type { TariffsPageData } from "@/src/types/tariffs";

type Props = {
  data: TariffsPageData;
};

export default function TariffsPage({ data }: Props) {
  const searchParams = useSearchParams();
  const selectedCategory = searchParams.get("category") ?? "";

  return (
    <div className="tariffsPage">
      <div className="mainSmall">

        {/* ===== Page Title ===== */}
        <TitlePage title={data.title} />

        {/* ===== Categories Slider ===== */}
        {data.categories.length > 0 && (
          <section className="tariffs_cat">
            <CategorySlider
              categories={data.categories.map((cat, idx) => ({
                id: idx,
                slug: cat.slug,
                label: cat.title,
              }))}
              basePath="/tariffs"
              selectedCategory={selectedCategory}
              mode="replace-url"
            />
          </section>
        )}

        {/* ===== Page Image ===== */}
        {data.image && (
          <section className="tariffs_img relative">
            <figure className="radius24 overflow w100 h100">
              <img
                src={data.image}
                alt={data.title}
                className="w100 h100 objectfitCover"
              />
            </figure>
          </section>
        )}

        {/* ===== Page HTML Content ===== */}
        <section className="tariffs_desc">
          <div
            className="desc"
            dangerouslySetInnerHTML={{ __html: data.content }}
          />
        </section>

        {/* ===== Tariff List ===== */}
        {data.tariffs.length > 0 && (
          <section className="tariffs_list">
            <div className="tariffsList">
              <ul>
                {data.tariffs.map((group, gIndex) => (
                  <li key={gIndex}>
                    {group.title && (
                      <label className="blueTxt">{group.title}</label>
                    )}

                    <ul className="tariffsList_lvlTwo">
                      {group.items.map((item, iIndex) => (
                        <li key={iIndex}>
                          <div className="tariffsList_item relative radius16 lightGrayBg">
                            <div className="tariffsList_item_content">
                              <p>{item.title}</p>
                              <p>{item.description}</p>
                            </div>
                          </div>
                        </li>
                      ))}
                    </ul>

                  </li>
                ))}
              </ul>
            </div>
          </section>
        )}

      </div>
    </div>
  );
}
