import { notFound } from "next/navigation";
import { getTariffsPage } from "@/src/lib/tariffsApi";
import TariffsPage from "./components/TariffsPage";

// ------------------ SEO ------------------
export async function generateMetadata() {
  const data = await getTariffsPage();
  if (!data) return {};

  return {
    title: data.title,
    description: "",
    robots: "noindex, nofollow",
    openGraph: {
      title: data.title,
      images: [{ url: data.image }],
    },
    alternates: {
      canonical: "",
    },
  };
}

// ------------------ PAGE ------------------
export default async function Page() {
  const data = await getTariffsPage();
  if (!data) return notFound();

  return <TariffsPage data={data} />;
}
