"use client";

import Tabs from "@/app/components/common/Tabs";
import TitlePage from "@/app/components/common/TitlePage";
import VisitorsGuideContent from "../components/VisitorsGuideContent";
import type { VisitorsGuideItem } from "../types/visitorsGuide";

type Props = {
  title: string;
  items: VisitorsGuideItem[];
};

export default function VisitorsGuidePage({ title, items }: Props) {
  return (
    <div className="visitorsGuidePage scientificEventsPage">
      <div className="mainSmall">
        <TitlePage title={title} />

        <section className="visitorsGuide_list scientificEvents-history">
          <Tabs
            tabs={items.map((item, index) => ({
              id: String(index),
              label: item.title,
              content: <VisitorsGuideContent tab={item} />,
            }))}
          />
        </section>
      </div>
    </div>
  );
}
