import { NextResponse } from "next/server";

export async function GET() {
  try {
    const base = process.env.NEXT_PUBLIC_API_BASE;

    const res = await fetch(
      `${base}/Doctors/api/v1/fa/departments/dropdown`,
      { cache: "no-store" }
    );

    const json = await res.json();

    const items =
      json?.data?.map((d: any) => ({
        id: d.id,
        title: d.title,
      })) || [];

    return NextResponse.json(items);
  } catch (error) {
    console.error("❌ API departments error:", error);
    return NextResponse.json([], { status: 500 });
  }
}
