import { NextResponse } from "next/server";

export async function GET() {
  try {
    const base = process.env.NEXT_PUBLIC_API_BASE;
    const endpoint = `${base}/Doctors/api/v1/fa/expertise/dropdown`;

    const res = await fetch(endpoint, { cache: "no-store" });

    if (!res.ok) {
      console.error("Failed to fetch expertises:", res.status);
      return NextResponse.json([], { status: 200 });
    }

    const json = await res.json();
    return NextResponse.json(json.data || []);
  } catch (err) {
    console.error("Expertises API Error:", err);
    return NextResponse.json([], { status: 200 }); 
  }
}
