// app/components/article/ArticleDetailPage.tsx

import NewsHeader from "@/app/(sections)/news/components/NewsHeader";
import NewsTopImage from "@/app/(sections)/news/components/NewsTopImage";
import NewsMeta from "@/app/(sections)/news/components/NewsMeta";
import NewsContent from "@/app/(sections)/news/components/NewsContent";
import RelatedNews from "@/app/(sections)/news/components/RelatedNews";
import Comments from "@/app/components/common/Comments";
import type { ArticleDetail } from "@/src/types/article";
import { commentsData } from "@/app/(sections)/news/data/commentsData";

interface Props {
  article: ArticleDetail;
  type: "news" | "education";
}

export default function ArticleDetailPage({ article, type }: Props) {
  return (
    <section className="blogDetailPage">
      <div className="mainSmall">

        <NewsHeader title={article.title} date={article.date || ""} />
        <NewsTopImage image={article.image || ""} title={article.title} />
        <NewsMeta
          readTime={article.readTime || ""}
          rating={article.rating ?? 4.9}
          commentsCount={article.commentsCount ?? 0}
        />

        <NewsContent contentHtml={article.contentHtml} />

        <Comments
          comments={commentsData}
          averageRate={4.6}
          type={type === "news" ? "article" : "education"}
          popupTitle={
            type === "news"
              ? "افزودن نظر درباره این خبر"
              : "افزودن نظر درباره این آموزش"
          }
          popupImage={article.image || ""}
          popupSubtitle={article.title}

          blogId={type === "education" ? article.id : undefined}
        />

        {article.related?.length > 0 && (
          <RelatedNews
            related={article.related.map((r, i) => ({
              id: i + 1,
              slug: r.slug,
              title: r.title,
              image: r.image || "",
              date: r.date || "",
              excerpt: "",
              readTime: r.readTime || "",
            }))}
          />
        )}

      </div>
    </section>
  );
}
