"use client";

import Link from "next/link";

interface BreadcrumbItem {
  label: string;
  href: string;
  active?: boolean;
}

interface BreadcrumbProps {
  items: BreadcrumbItem[];
}

export default function Breadcrumb({ items }: BreadcrumbProps) {
  return (
    <section className="breadcrumbMaster">
      <div className="mainSmall">
        <nav className="navbrcmb" aria-label="breadcrumb">
          <ul
            className="breadcrumb"
            itemScope
            itemType="http://schema.org/BreadcrumbList"
          >
            {items.map((item, index) => {
              const isActive = item.active ?? index === items.length - 1;

              return (
                <li
                  key={item.href}
                  itemProp="itemListElement"
                  itemScope
                  itemType="http://schema.org/ListItem"
                >
                  {isActive ? (
                    <span className="cur" itemProp="name">
                      {item.label}
                    </span>
                  ) : (
                    <Link href={item.href} itemProp="item">
                      <span itemProp="name">{item.label}</span>
                    </Link>
                  )}
                  <meta itemProp="position" content={`${index + 1}`} />
                </li>
              );
            })}
          </ul>
        </nav>
      </div>
    </section>
  );
}
