"use client";

import { usePathname } from "next/navigation";
import Breadcrumb from "./Breadcrumb";
import { breadcrumbLabels } from "@/src/data/breadcrumbLabels";
import { breadcrumbSources } from "@/src/data/breadcrumbSources";
import { useEffect, useState } from "react";

export default function BreadcrumbWrapper() {
  const pathname = usePathname();
  const parts = pathname.split("/").filter(Boolean);

  const [items, setItems] = useState<
    { label: string; href: string; active: boolean }[]
  >([]);

  useEffect(() => {
    async function buildBreadcrumb() {
      const temp: any[] = [{ label: "خانه", href: "/" }];

      for (let i = 0; i < parts.length; i++) {
        const part = parts[i];
        const href = "/" + parts.slice(0, i + 1).join("/");

        let label =
          breadcrumbLabels[part] ||
          decodeURIComponent(part.replace(/-/g, " "));

        let parentKey = parts[i - 1];

        // --------------------------
        // Gallery
        // --------------------------
        if (parts[i - 2] === "gallery" && parts[i - 1] === "list") {
          parentKey = "galleryCategory"; // Gallery list
        }
        if (parts[i - 1] === "gallery" && i === parts.length - 1) {
          parentKey = "gallery"; //  Gallery detail
        }

        // --------------------------

        // --------------------------
        // Blog
        // --------------------------
        if (parts[i - 2] === "news" && parts[i - 1] === "list") {
          parentKey = "newsCategory"; //  blog list
        }
        if (parts[i - 1] === "news" && i === parts.length - 1) {
          parentKey = "news"; //  blog detail
        }
        // Department
        // --------------------------
        if (parts[i - 2] === "departmans" && parts[i - 1] === "departmans") {
          parentKey = "departmans";
        }
        // --------------------------
        // (tutorial)
        // --------------------------
        if (parts[i - 1] === "education" && i === parts.length - 1) {
          parentKey = "education"; // tutorial detail
        }
 if (parts[i - 2] === "education" && parts[i - 1] === "list") {
          parentKey = "educationCategory"; // tutorial list
        }
        // --------------------------
        // doctors
        // --------------------------
        if (parts[i - 1] === "doctors" && i === parts.length - 1) {
          parentKey = "doctors";
        }

        // --------------------------
        // board
        // --------------------------
        if (parts[i - 1] === "board" && i === parts.length - 1) {
          parentKey = "board";
        }

        // --------------------------
        // --------------------------
        if (i === parts.length - 1 && breadcrumbSources[parentKey]) {
          const result = await breadcrumbSources[parentKey].findFn(part);
          if (result) {
            label =
              result.fullName ||
              result.name ||
              result.pageTitle ||
              result.title ||
              label;
          }
        }

        temp.push({
          label,
          href,
          active: i === parts.length - 1,
        });
      }

      setItems(temp);
    }

    buildBreadcrumb();
  }, [pathname]);

  return <Breadcrumb items={items} />;
}
