type CmsPageDetailProps = {
  title: string;
  image: string | null;
  content: string | null;
};

export default function CmsPageDetail({ title, image, content }: CmsPageDetailProps) {
  return (
    <div className="cmsPage">
      <div className="mainSmall">

        {/* ----- IMAGE ----- */}
        {image ? (
          <div className="cmsPage_img relative w100">
            <figure className="radius20 overflow w100 h100">
              <img
                src={image}
                alt={title}
                loading="lazy"
                className="w100 h100 objectfitCover"
              />
            </figure>
          </div>
        ) : null}

        {/* ----- CONTENT (HTML SAFE) ----- */}
        {content ? (
          <div
            className="desc"
            dangerouslySetInnerHTML={{ __html: content }}
          />
        ) : (
          <p className="desc">محتوایی برای نمایش وجود ندارد.</p>
        )}

      </div>
    </div>
  );
}
