"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import type { CategoryItem } from "@/src/types/Categories";
import Link from "next/link";
import { useRouter } from "next/navigation";

type Props = {
  categories: CategoryItem[];
  basePath: string;
  selectedCategory: string;
  mode?: "link" | "replace-url";
};

export default function CategorySlider({
  categories,
  basePath,
  selectedCategory,
  mode = "link",
}: Props) {
  const router = useRouter();

  const handleClick = (slug: string) => {
    if (mode === "replace-url") {
      const newUrl = `${basePath}?category=${encodeURIComponent(slug)}&page=1`;
      router.push(newUrl, { scroll: false });
    }
  };

  return (
    <div className="blogCat flex flexSpace alignCenter">
      <div className="blogCat_slider swiper-container">
        <Swiper
          modules={[Navigation, Pagination]}
          speed={900}
          slidesPerView={6}
          spaceBetween={20}
          navigation={{
            nextEl: ".blogCat_slider-next",
            prevEl: ".blogCat_slider-prev",
          }}
          pagination={{ el: ".servicesPagination", clickable: true }}
          breakpoints={{
            300: { slidesPerView: 2, spaceBetween: 10 },
            480: { slidesPerView: 2, spaceBetween: 10 },
            720: { slidesPerView: 5, spaceBetween: 10 },
            1000: { slidesPerView: 6 },
            1249: { slidesPerView: 6 },
          }}
        >
          {categories.map((cat) => (
            <SwiperSlide key={cat.slug}>
              {mode === "link" ? (
                <Link
                  href={`${basePath}/${encodeURIComponent(cat.slug)}?page=1`}
                  className={`
                    blogCat_slider_item flex flexCenter alignCenter radius12
                    ${cat.slug === selectedCategory ? "activeCat" : ""}
                  `}
                >
                  {cat.icon && (
                    <img src={cat.icon} alt={cat.label} width={20} height={20} />
                  )}
                  {cat.label}
                </Link>
              ) : (
                <button
                  onClick={() => handleClick(cat.slug)}
                  className={`
                    blogCat_slider_item flex flexCenter alignCenter radius12
                    ${cat.slug === selectedCategory ? "activeCat" : ""}
                  `}
                >
                  {cat.icon && (
                    <img src={cat.icon} alt={cat.label} width={20} height={20} />
                  )}
                  {cat.label}
                </button>
              )}
            </SwiperSlide>
          ))}
        </Swiper>
      </div>

      {/* Navigation */}
      <div className="navBtn flex flexEnd alignCenter">
        <div className="publicBtn radius14 flex flexCenter alignCenter blogCat_slider-prev">
          <svg xmlns="http://www.w3.org/2000/svg" width="8" height="17" viewBox="0 0 8 17" fill="none">
            <path d="M0.734937 0.594995C0.907012 0.594995 1.07909 0.65839 1.21494 0.794239L7.11984 6.69914C8.07984 7.65914 8.07984 9.23499 7.11984 10.195L1.21494 16.0999C0.952295 16.3625 0.517579 16.3625 0.254937 16.0999C-0.00770473 15.8373 -0.00770473 15.4025 0.254937 15.1399L6.15984 9.23499C6.59456 8.80027 6.59456 8.09386 6.15984 7.65914L0.254937 1.75424C-0.00770473 1.4916 -0.00770473 1.05688 0.254937 0.794239C0.390786 0.667447 0.562861 0.594995 0.734937 0.594995Z" fill="#0C0C0C"/>
          </svg>
        </div>
        <div className="publicBtn radius14 flex flexCenter alignCenter blogCat_slider-next">
          <svg xmlns="http://www.w3.org/2000/svg" width="8" height="17" viewBox="0 0 8 17" fill="none">
            <path d="M7.26506 16.405C7.09299 16.405 6.92091 16.3416 6.78506 16.2058L0.880156 10.3009C-0.0798438 9.34086 -0.0798438 7.76501 0.880156 6.80501L6.78506 0.900106C7.0477 0.637465 7.48242 0.637465 7.74506 0.900106C8.0077 1.16275 8.0077 1.59746 7.74506 1.86011L1.84016 7.76501C1.40544 8.19973 1.40544 8.90614 1.84016 9.34086L7.74506 15.2458C8.0077 15.5084 8.0077 15.9431 7.74506 16.2058C7.60921 16.3326 7.43714 16.405 7.26506 16.405Z" fill="#0C0C0C"/>
          </svg>
        </div>
      </div>
    </div>
  );
}
