"use client";
import { useState } from "react";
import Popup from "@/app/components/common/Popup";
import CommentPopup from "../common/CommentPopup";

export interface CommentItem {
  id: string | number;
  name: string;
  date: string;
  rate: number;
  text: string;
}

interface CommentsProps {
  comments: CommentItem[];
  averageRate: number;
  type?: "article" | "doctor" | "education";
  popupTitle?: string;
  popupImage?: string;
  popupSubtitle?: string;
  doctorId?: string;
  blogId?: string; 
}

export default function Comments({
  comments,
  averageRate,
  type = "article",
  popupTitle,
  popupImage,
  popupSubtitle,
  doctorId,
  blogId,
}: CommentsProps) {
  const [isPopupOpen, setIsPopupOpen] = useState(false);

  return (
    <section className="userComments">

     {/* --- Title --- */}
      <div className="titleBox relative radius24 bgLightGray flex flexCenter alignCenter">
        <span className="txtCenter">دیدگاه کاربران</span>
      </div>

      <div className="commentSec flex flexSpace alignStart">

        {/* --- List of comments --- */}
        <div className="userComments_list">
          <ul>
            {comments.map((c) => (
              <li key={c.id}>
                <div className="userComments_list_item">
                  
                  <div className="userComments_list_head flex flexSpace alignCenter">
                    <div className="userComments_list_head_r flex flexStart alignCenter">
                      <div className="iconItem">
                        {/* SVG  */}
                         <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M12.0002 22.7501C11.3302 22.7501 10.6502 22.5801 10.0502 22.2301L4.11016 18.8001C2.91016 18.1001 2.16016 16.8101 2.16016 15.4201V8.58011C2.16016 7.19011 2.91016 5.90011 4.11016 5.20011L10.0502 1.77012C11.2502 1.07012 12.7402 1.07012 13.9502 1.77012L19.8902 5.20011C21.0902 5.90011 21.8402 7.19011 21.8402 8.58011V15.4201C21.8402 16.8101 21.0902 18.1001 19.8902 18.8001L13.9502 22.2301C13.3502 22.5801 12.6702 22.7501 12.0002 22.7501ZM12.0002 2.7501C11.5902 2.7501 11.1702 2.8601 10.8002 3.0701L4.86016 6.5001C4.12016 6.9301 3.66016 7.72011 3.66016 8.58011V15.4201C3.66016 16.2701 4.12016 17.0701 4.86016 17.5001L10.8002 20.9301C11.5402 21.3601 12.4602 21.3601 13.2002 20.9301L19.1402 17.5001C19.8802 17.0701 20.3402 16.2801 20.3402 15.4201V8.58011C20.3402 7.73011 19.8802 6.9301 19.1402 6.5001L13.2002 3.0701C12.8302 2.8601 12.4102 2.7501 12.0002 2.7501Z" fill="#3D3D3D"></path>
                                <path d="M11.9999 11.7501C10.2999 11.7501 8.91992 10.37 8.91992 8.67004C8.91992 6.97004 10.2999 5.59009 11.9999 5.59009C13.6999 5.59009 15.0799 6.97004 15.0799 8.67004C15.0799 10.37 13.6999 11.7501 11.9999 11.7501ZM11.9999 7.09009C11.1299 7.09009 10.4199 7.80004 10.4199 8.67004C10.4199 9.54004 11.1299 10.2501 11.9999 10.2501C12.8699 10.2501 13.5799 9.54004 13.5799 8.67004C13.5799 7.80004 12.8699 7.09009 11.9999 7.09009Z" fill="#3D3D3D"></path>
                                <path d="M16 17.4101C15.59 17.4101 15.25 17.0701 15.25 16.6601C15.25 15.2801 13.79 14.1501 12 14.1501C10.21 14.1501 8.75 15.2801 8.75 16.6601C8.75 17.0701 8.41 17.4101 8 17.4101C7.59 17.4101 7.25 17.0701 7.25 16.6601C7.25 14.4501 9.38 12.6501 12 12.6501C14.62 12.6501 16.75 14.4501 16.75 16.6601C16.75 17.0701 16.41 17.4101 16 17.4101Z" fill="#3D3D3D"></path>
                         </svg>
                      </div>
                      <div className="userName">
                        <strong>{c.name}</strong>
                      </div>
                    </div>

                    <div className="userComments_list_head_l">
                      <div
                        className="star_rate"
                        style={{ "--rate": c.rate } as React.CSSProperties}
                      ></div>
                    </div>
                  </div>

                  <div className="time">
                    <time>{c.date}</time>
                  </div>

                  <div className="desc">
                    <p>{c.text}</p>
                  </div>
                </div>
              </li>
            ))}
          </ul>
        </div>

       {/* --- Comment section --- */}
        <div className="insertComment boxShadow radius12">
          <div className="insertComment_up flex flexSpace">
            <ul className="user_rates">
              {[5, 4, 3, 2, 1].map((rate) => (
                <li key={rate} className="user-rate-item">
                  <span className="bar__rate">
                    <span className="progress" style={{ "--rate": 3 } as React.CSSProperties}></span>
                    <label>{rate}</label>
                  </span>
                </li>
              ))}
            </ul>

            <div className="rating-star flex flexDirColumn alignEnd">
              <span className="ratingShow blueTxt fontBold">{averageRate.toFixed(1)}</span>
              <span className="commentLbl">
                <label>{comments.length}</label> نظر
              </span>
              <div
                className="star_rate"
                style={{ "--rate": averageRate } as React.CSSProperties}
              ></div>
            </div>
          </div>

          <div className="insertComment-down">
            <div className="insertComment-down_txt flex flexCenter alignCenter">
              <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none">
                <path d="M14.9837..." stroke="#3D3D3D"></path>
              </svg>
              <p>
                {type === "doctor"
                  ? "نظر خود را درباره این پزشک بنویسید"
                  : "نظرات خود را درباره این مقاله بنویسید"}
              </p>
            </div>

            <button
              className="addBtn bgGreen radius40 flex flexCenter alignCenter w100 whiteTxt animationGreenBox"
              onClick={() => setIsPopupOpen(true)}
            >
              افزودن دیدگاه
            </button>
          </div>
        </div>
      </div>

      {/* Popup */}
      <Popup
        isOpen={isPopupOpen}
        onClose={() => setIsPopupOpen(false)}
        popupClass="popupComment"
      >
       <CommentPopup
  type={type}
  title={popupTitle}
  image={popupImage}
  subtitle={popupSubtitle}
  
  blogId={
    type === "article"
      ? blogId
      : type === "education"
      ? blogId
      : undefined
  }

  doctorId={type === "doctor" ? doctorId : undefined}
  onSuccess={() => setIsPopupOpen(false)}
/>

      </Popup>
    </section>
  );
}
