"use client";

import { useState, useRef } from "react";

type HomeFaq = {
  id: number;
  question: string;
  answer: string;
};

type DepartmentFaq = {
  title: string;
  description: string | null;
};

type FaqListProps = {
  items: (HomeFaq | DepartmentFaq)[];
  className?: string;
};

export default function FaqList({ items, className = "" }: FaqListProps) {
  const [openId, setOpenId] = useState<number | null>(null);

 // Final solution — use array instead of object
  const contentRefs = useRef<Array<HTMLDivElement | null>>([]);

  const toggleFaq = (id: number) => {
    setOpenId(openId === id ? null : id);
  };

  return (
    <div className={`faqsList ${className}`}>
      <ul>
        {items.map((item, index) => {
          const isOpen = openId === index;

          const question =
            "question" in item ? item.question : item.title;

          const answer =
            "answer" in item ? item.answer : item.description || "";

          return (
            <li key={index}>
              <div className="faqListItem radius8 overflow-hidden relative">

                {/* --- Header row --- */}
                <div
                  className={`faqListItem_up flex flexSpace alignCenter cursor-pointer ${
                    isOpen ? "active" : ""
                  }`}
                  onClick={() => toggleFaq(index)}
                >
                  <p>{question}</p>
                  <i
                    className={`fa-solid txtGray txt14 transition-transform duration-300 ${
                      isOpen ? "fa-angle-up" : "fa-angle-down"
                    }`}
                  ></i>
                </div>

                {/* --- Content --- */}
                <div
                  ref={(el) => {
                    contentRefs.current[index] = el;
                  }}
                  className="faqListItem_down transition-all duration-500 ease-in-out overflow-hidden"
                  style={{
                    maxHeight: isOpen
                      ? `${contentRefs.current[index]?.scrollHeight || 0}px`
                      : "0px",
                    opacity: isOpen ? 1 : 0,
                  }}
                >
                  <p>{answer}</p>
                </div>

              </div>
            </li>
          );
        })}
      </ul>
    </div>
  );
}
