"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import { Department } from "@/src/types/hospitalDepartments";

interface Props {
  data: Department[];
}

export default function HospitalDepartmentsSlider({ data }: Props) {
  return (
    <div className="HospitalDepartmentsInfo">
      <Swiper
        modules={[Navigation, Pagination, Autoplay]}
        speed={900}
        slidesPerView={4}
        spaceBetween={40}
        autoplay={{ delay: 6000, disableOnInteraction: false }}
        pagination={{ clickable: true }}
        navigation={{
          nextEl: ".HospitalDepartmentsInfoNxt",
          prevEl: ".HospitalDepartmentsInfoPrv",
        }}
        breakpoints={{
          300: { slidesPerView: 1, spaceBetween: 30 },
          480: { slidesPerView: 1, spaceBetween: 30 },
          720: { slidesPerView: 2, spaceBetween: 30 },
          1001: { slidesPerView: 4, spaceBetween: 30 },
          1249: { slidesPerView: 4, spaceBetween: 30 },
        }}
        className="HospitalDepartmentsInfo_slider"
      >
        {data.map((dep) => (
          <SwiperSlide key={dep.id}>
            <div className="HospitalDepartmentsInfo_slider_item radius16 boxShadow">
              <figure className="HospitalDepartmentsInfo_slider_icon flex flexCenter alignCenter radius50 overflow">
                <img src={dep.icon} alt={dep.title} />
              </figure>

              <a href="#" className="HospitalDepartmentsInfoTitle txtCenter">
                {dep.title}
              </a>

              <a
                href={`tel:${dep.phone}`}
                className="HospitalDepartmentsInfoNumber flex flexCenter alignCenter"
              >
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="20"
                  height="20"
                  viewBox="0 0 20 20"
                  fill="none"
                  aria-hidden="true"
                >
                  <path
                    d="M18.3087 15.2751C18.3087 15.5751 18.242 15.8834 18.1003 16.1834C17.9587 16.4834 17.7753 16.7667 17.5337 17.0334C17.1253 17.4834 16.6753 17.8084 16.167 18.0167C15.667 18.2251 15.1253 18.3334 14.542 18.3334C13.692 18.3334 12.7837 18.1334 11.8253 17.7251C10.867 17.3167 9.90866 16.7667 8.95866 16.0751C8.00033 15.3751 7.09199 14.6001 6.22533 13.7417C5.36699 12.8751 4.59199 11.9667 3.90033 11.0167C3.21699 10.0667 2.66699 9.11675 2.26699 8.17508C1.86699 7.22508 1.66699 6.31675 1.66699 5.45008C1.66699 4.88341 1.76699 4.34175 1.96699 3.84175C2.16699 3.33341 2.48366 2.86675 2.92533 2.45008C3.45866 1.92508 4.04199 1.66675 4.65866 1.66675C4.89199 1.66675 5.12533 1.71675 5.33366 1.81675C5.55033 1.91675 5.74199 2.06675 5.89199 2.28341L7.82533 5.00842C7.97533 5.21675 8.08366 5.40841 8.15866 5.59175C8.23366 5.76675 8.27533 5.94175 8.27533 6.10008C8.27533 6.30008 8.21699 6.50008 8.10033 6.69175C7.99199 6.88341 7.83366 7.08341 7.63366 7.28341L7.00033 7.94175C6.90866 8.03341 6.86699 8.14175 6.86699 8.27508C6.86699 8.34175 6.87533 8.40008 6.89199 8.46675C6.91699 8.53341 6.94199 8.58341 6.95866 8.63341C7.10866 8.90841 7.36699 9.26675 7.73366 9.70008C8.10866 10.1334 8.50866 10.5751 8.94199 11.0167C9.39199 11.4584 9.82533 11.8667 10.267 12.2417C10.7003 12.6084 11.0587 12.8584 11.342 13.0084C11.3837 13.0251 11.4337 13.0501 11.492 13.0751C11.5587 13.1001 11.6253 13.1084 11.7003 13.1084C11.842 13.1084 11.9503 13.0584 12.042 12.9667L12.6753 12.3417C12.8837 12.1334 13.0837 11.9751 13.2753 11.8751C13.467 11.7584 13.6587 11.7001 13.867 11.7001C14.0253 11.7001 14.192 11.7334 14.3753 11.8084C14.5587 11.8834 14.7503 11.9917 14.9587 12.1334L17.717 14.0917C17.9337 14.2417 18.0837 14.4167 18.1753 14.6251C18.2587 14.8334 18.3087 15.0417 18.3087 15.2751Z"
                    stroke="#6D6D6D"
                  />
                </svg>
                <span>{dep.phone}</span>
              </a>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>

      {/* Pagination & Navigation */}
      <div className="swiper-pagination HospitalDepartmentsInfoPagination publicPager"></div>

      <div className="navSlider flex flexEnd alignCenter z-index">
        <div className="radius12 flex flexCenter alignCenter HospitalDepartmentsInfoNxt publicBtn">
          <i className="fa-light fa-chevron-right"></i>
        </div>
        <div className="radius12 flex flexCenter alignCenter HospitalDepartmentsInfoPrv publicBtn">
          <i className="fa-light fa-angle-left"></i>
        </div>
      </div>
    </div>
  );
}
