interface PaginationProps {
  currentPage: number;
  totalPages: number;
  onPageChange: (page: number) => void;
}

export default function Pagination({ currentPage, totalPages, onPageChange }: PaginationProps) {
  const pages = Array.from({ length: totalPages }, (_, i) => i + 1);

  return (
    <div className="pagingSec flex flexCenter alignCenter">
      <ul className="pagingSec_list flex flexCenter alignCenter">

        {/* previous */}
        <li className="publicBtn flex flexCenter alignCenter">
          <button
            className="flex flexCenter alignCenter transition radius8 grayLightBox"
            disabled={currentPage <= 1}
            onClick={() => onPageChange(currentPage - 1)}
          >
            <svg xmlns="http://www.w3.org/2000/svg" width="9" height="16" viewBox="0 0 9 16" fill="none">
              <path d="M1.42505 14.5999L6.85838 9.16657C7.50005 8.5249 7.50005 7.4749 6.85838 6.83324L1.42505 1.3999" stroke="#3D3D3D" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
            </svg>
          </button>
        </li>

        {/* Page number */}
        {pages.map((page) => (
          <li key={page} className={page === currentPage ? "activePage" : ""}>
            <button
              className={`flex flexCenter alignCenter transition radius8 ${
                page === currentPage ? "activeBtn" : ""
              }`}
              onClick={() => onPageChange(page)}
            >
              {page}
            </button>
          </li>
        ))}

        {/* next */}
        <li className="publicBtn flex flexCenter alignCenter">
          <button
            className="flex flexCenter alignCenter transition radius8 grayLightBox"
            disabled={currentPage >= totalPages}
            onClick={() => onPageChange(currentPage + 1)}
          >
            <svg xmlns="http://www.w3.org/2000/svg" width="9" height="16" viewBox="0 0 9 16" fill="none">
              <path d="M7.57495 14.5999L2.14162 9.16657C1.49995 8.5249 1.49995 7.4749 2.14162 6.83324L7.57495 1.3999" stroke="#4F4F4F" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
            </svg>
          </button>
        </li>

      </ul>
    </div>
  );
}
