"use client";

import { ReactNode } from "react";

type PopupProps = {
  isOpen: boolean;
  onClose: () => void;
  children: ReactNode;
  popupClass?: string;
};

export default function Popup({ isOpen, onClose, children, popupClass = "" }: PopupProps) {
  return (
    <div
      className={`popup-public popupOverlay ${popupClass} ${isOpen ? "is-active" : ""}`}
      onClick={(e) => {
        if (e.target === e.currentTarget) {
          onClose();
        }
      }}
    >
      <div className="popup-body">
        <a
          href="#"
          className="popup-close"
          onClick={(e) => {
            e.preventDefault();
            onClose();
          }}
        >
          {/* close btn*/}
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="40"
            height="40"
            viewBox="0 0 40 40"
            fill="none"
          >
            <path
              d="M19.9987 36.6667C29.1654 36.6667 36.6654 29.1667 36.6654 20C36.6654 10.8333 29.1654 3.33333 19.9987 3.33333C10.832 3.33333 3.33203 10.8333 3.33203 20C3.33203 29.1667 10.832 36.6667 19.9987 36.6667Z"
              stroke="#0C0C0C"
              strokeWidth="1.5"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M15.2852 24.7167L24.7185 15.2833"
              stroke="#0C0C0C"
              strokeWidth="1.5"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M24.7185 24.7167L15.2852 15.2833"
              stroke="#0C0C0C"
              strokeWidth="1.5"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
          </svg>
        </a>

        {children}
      </div>
    </div>
  );
}
