"use client";

import { useState } from "react";

type Tab = {
  id: string;
  label: string; 
  content:string | React.ReactNode;
};

type TabsProps = {
  tabs: Tab[];
};

export default function Tabs({ tabs }: TabsProps) {
  const [activeTab, setActiveTab] = useState(tabs[0]?.id);

  return (
    <div className="tabSection flex flexSpace alignStart w100" data-parent>
      <ul className="tabMenu" data-Ptab>
            {tabs.map((tab) => (
              <li>
                    <a
            key={tab.id}
            data-tab
            className={activeTab === tab.id ? "tabSectionItem flex flexStart alignCenter transition fontMed fontBold grayTxt active" : "tabSectionItem flex flexStart alignCenter transition fontMed fontBold grayTxt"}
            onClick={() => setActiveTab(tab.id)}
            >
            <i className="Icon_item ph ph-bookmark-simple"></i> 
            <span>{tab.label}</span>
            </a>
              </li>
        
        ))} 
      </ul>

     {/* Tab content */}
        {tabs.map((tab) => (
          <div
            key={tab.id}
            data-Tlist
            className={`tabbox ${activeTab === tab.id ? "active" : ""}`}
          >
            {tab.content}
          </div>
        ))}

    </div>
  );
}
