type PageHeaderProps = {
  title: string;
};

export default function PageHeader({ title }: PageHeaderProps) {
  return (
    <section className="drListPage_head titleBox relative radius24 bgLightGray flex flexCenter alignCenter">
      <span className="txtCenter">{title}</span>

      <div className="shapeLeft absolute" aria-hidden="true">
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="204"
          height="143"
          viewBox="0 0 204 143"
          fill="none"
        >
          <g filter="url(#filter0_d_641_2395)">
            <path
              d="M16.8652 27.8062L174.299 131.477L16.8682 71.8514L16.8652 27.8062Z"
              fill="url(#paint0_linear_641_2395)"
            />
            <path
              d="M48.5429 14.7852L49.8027 49.8434L16.7988 27.8068L48.5429 14.7852Z"
              fill="url(#paint1_linear_641_2395)"
            />
            <path
              d="M193.299 101.927L174.299 131.477L125.299 99.4233L193.299 101.927Z"
              fill="url(#paint2_linear_641_2395)"
            />
          </g>
          <defs>
            <filter
              id="filter0_d_641_2395"
              x="6.79883"
              y="0.785156"
              width="196.5"
              height="136.691"
              filterUnits="userSpaceOnUse"
              colorInterpolationFilters="sRGB"
            >
              <feFlood floodOpacity="0" result="BackgroundImageFix" />
              <feColorMatrix
                in="SourceAlpha"
                type="matrix"
                values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                result="hardAlpha"
              />
              <feOffset dy="-4" />
              <feGaussianBlur stdDeviation="5" />
              <feComposite in2="hardAlpha" operator="out" />
              <feColorMatrix
                type="matrix"
                values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"
              />
              <feBlend
                mode="normal"
                in2="BackgroundImageFix"
                result="effect1_dropShadow_641_2395"
              />
              <feBlend
                mode="normal"
                in="SourceGraphic"
                in2="effect1_dropShadow_641_2395"
                result="shape"
              />
            </filter>
            <linearGradient
              id="paint0_linear_641_2395"
              x1="130.816"
              y1="60.5904"
              x2="92.1588"
              y2="143.206"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#0E5352" />
              <stop offset="1" stopColor="#05C7BB" />
            </linearGradient>
            <linearGradient
              id="paint1_linear_641_2395"
              x1="55.7988"
              y1="14.7852"
              x2="36.7633"
              y2="36.2895"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#067F7B" />
              <stop offset="1" stopColor="#0E5352" />
            </linearGradient>
            <linearGradient
              id="paint2_linear_641_2395"
              x1="187.786"
              y1="150.488"
              x2="239.273"
              y2="157.476"
              gradientUnits="userSpaceOnUse"
            >
              <stop stopColor="#0E5352" />
              <stop offset="1" stopColor="#067F7B" />
            </linearGradient>
          </defs>
        </svg>
      </div>
    </section>
  );
}
