"use client";

import Link from "next/link";
import Image from "next/image";
import dynamic from "next/dynamic";
import type { FooterData } from "@/src/types/footer";
import MapRoutingList from "../map/MapRoutingList";

const FooterMap = dynamic(() => import("@/app/components/map/Map"), {
  ssr: false,
});

export default function FooterClient({ footerData }: { footerData: FooterData }) {
  const { contact, footerText, usefulLinks, visitorGuide, socials, badges } = footerData;

  return (
    <footer>
      <div className="mainSmall">

        <div className="footerTop flex flexSpace alignStart">

          <div className="footerTop_r">
            <div className="logoSec flex flexStart alignCenter">
              <div className="logo flex flexStart alignCenter">
                <Link
                  href="/"
                  className="bgWhite radius6 flex flexCenter alignCenter hoverImg overflow"
                >
                  <Image
                    src="/images/logoMain.svg"
                    alt="لوگو"
                    width={60}
                    height={60}
                  />
                </Link>
                <Link
                  href="/"
                  className="bgWhite radius6 flex flexCenter alignCenter hoverImg overflow"
                >
                  <Image
                    src="/images/logoNew.svg"
                    alt="لوگو"
                    width={80}
                    height={40}
                  />
                </Link>
              </div>
              <div className="headTitle whiteTxt flex flexDirColumn txtCenter">
                <span className="txt20">بیمارستان فوق تخصصی رضوی</span>
                <label>
                  <strong>Razavi</strong> Superspecialty Hospital
                </label>
              </div>
            </div>

            {footerText && (
              <div className="desc whiteTxt">
                <p>{footerText}</p>
              </div>
            )}
          </div>


          <div className="footerTop_c flex flexStart alignStart">
            <div className="footerMenu">
              <div className="footerTitle whiteTxt">
                <strong>لینک های مفید</strong>
              </div>
              <ul>
                {usefulLinks.map((link) => (
                  <li key={link.id}>
                    {link.isInternal ? (
                      <Link href={link.url || "#"} target={link.target || "_self"}>
                        {link.title}
                      </Link>
                    ) : (
                      <a href={link.url || "#"} target={link.target || "_self"}>
                        {link.title}
                      </a>
                    )}
                  </li>
                ))}
              </ul>
            </div>

            <div className="footerMenu">
              <div className="footerTitle whiteTxt">
                <strong>راهنمای مراجعین</strong>
              </div>
              <ul>
                {visitorGuide.map((link) => (
                  <li key={link.id}>
                    {link.isInternal ? (
                      <Link href={link.url || "#"} target={link.target || "_self"}>
                        {link.title}
                      </Link>
                    ) : (
                      <a href={link.url || "#"} target={link.target || "_self"}>
                        {link.title}
                      </a>
                    )}
                  </li>
                ))}
              </ul>
            </div>
          </div>


          <div className="footerTop_l">
            <div className="footerTitle whiteTxt">
              <strong>مجوزها</strong>
            </div>
            <div className="enamadList">
              <ul className="flex flexSpace alignCenter">
                {badges.map((badge, i) => (
                  <li key={i}>
                    <a
                      href={badge.url}
                      target="_blank"
                      className="enamadList_item radius12 flex flexCenter alignCenter overflow"
                    >
                      <Image
                        src={badge.picture}
                        alt={badge.title}
                        width={80}
                        height={80}
                      />
                    </a>
                  </li>
                ))}
              </ul>
            </div>
          </div>
        </div>

        <div className="footerCenter">
          <div className="contactList">
            <ul>
              <li>
                <div className="contactList_item">
                  <div className="contactList_item_title flex flexStart alignCenter whiteTxt">
                    <i className="fa-solid fa-location-dot"></i>
                    <strong>آدرس بیمارستان</strong>
                  </div>
                  <address>{contact.address}</address>
                </div>
              </li>

              <li>
                <div className="contactList_item">
                  <div className="contactList_item_title flex flexStart alignCenter whiteTxt">
                    <i className="fa-solid fa-phone"></i>
                    <strong>شماره تماس</strong>
                  </div>
                  <a href={`tel:${contact.primaryPhone}`}>{contact.primaryPhone}</a>
                </div>
              </li>

              <li>
                <div className="contactList_item">
                  <div className="contactList_item_title flex flexStart alignCenter whiteTxt">
                    <i className="fa-solid fa-fax"></i>
                    <strong>فکس</strong>
                  </div>
                  <span>{contact.fax}</span>
                </div>
              </li>

              <li>
                <div className="contactList_item">
                  <div className="contactList_item_title flex flexStart alignCenter whiteTxt">
                    <i className="fa-solid fa-envelope"></i>
                    <strong>پست الکترونیک</strong>
                  </div>
                  <a href={`mailto:${contact.email}`}>{contact.email}</a>
                </div>
              </li>
            </ul>
          </div>

          <div className="mapFooter relative">
            <FooterMap
              latitude={contact.latitude}
              longitude={contact.longitude}
            />
            <MapRoutingList
              neshan={contact.neshanUrlNavigation}
              google={contact.googleMapUrlNavigation}
              waze={contact.wazeUrlNavigation}
            />
          </div>
        </div>

        <div className="footerBottom flex flexSpace alignCenter">
          <div className="socialList">
            <ul className="flex alignCenter">
              {socials.map((s, i) => (
                <li key={i}>
                  <a
                    href={s.url}
                    target="_blank"
                    className="socialList_item radius50 flex flexCenter alignCenter"
                  >
                    <Image src={s.icon} alt={s.title} width={30} height={30} />
                  </a>
                </li>
              ))}
            </ul>
          </div>
          <div className="copyRight whiteTxt txt14">
            <p>کلیه حقوق این سرویس محفوظ و متعلق به بیمارستان رضوی می‌باشد</p>
          </div>
        </div>
      </div>
    </footer>
  );
}
