"use client";

import { useState } from "react";
import Link from "next/link";
import Popup from "@/app/components/common/Popup";

export default function ResponsiveMenu() {
  const [open, setOpen] = useState(false);
  const [activeTab, setActiveTab] = useState("tab1");

  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };

  return (
    <>

      <div
        className="humberger-menu"
        onClick={() => setOpen(true)}
        aria-label="باز کردن منوی موبایل"
      >
        <div className="bar1"></div>
        <div className="bar2"></div>
        <div className="bar3"></div>
      </div>


      <Popup
        isOpen={open}
        onClose={() => setOpen(false)}
        popupClass="popupMenuResponsive"
      >

          <div className="menu-responsive flex flexCenter alignCenter">
            <figure className="menu-responsive_logo">
              <img src="/images/logoMain.svg" alt="لوگو بیمارستان رضوی" />
            </figure>
            <figure className="menu-responsive_logoSlogan">
              <img src="/images/logoNew.svg" alt="لوگو انگلیسی" />
            </figure>
          </div>

          <div className="public-box-responvise">
            <div className="tabSection">
              <ul className="tabMenu flex flexStart alignCenter">
                <li>
                  <button
                    className={`tabSectionItem ${
                      activeTab === "tab1" ? "active" : ""
                    }`}
                    onClick={() => handleTabClick("tab1")}
                  >
                    <i className="Icon_item ph ph-list-bullets"></i>
                    <span>بخش‌ها</span>
                  </button>
                </li>
                <li>
                  <button
                    className={`tabSectionItem ${
                      activeTab === "tab2" ? "active" : ""
                    }`}
                    onClick={() => handleTabClick("tab2")}
                  >
                    <i className="Icon_item ph ph-bookmark-simple"></i>
                    <span>فهرست</span>
                  </button>
                </li>
                <li>
                  <button
                    className={`tabSectionItem ${
                      activeTab === "tab3" ? "active" : ""
                    }`}
                    onClick={() => handleTabClick("tab3")}
                  >
                    <i className="Icon_item ph ph-bookmark-simple"></i>
                    <span>نوبت‌دهی</span>
                  </button>
                </li>
              </ul>

              {activeTab === "tab1" && (
                <div className="tabbox active">
                  <div className="tabpanel">
                      <ul className="publicList">
                    <li className="flex flexStart alignStart">
                      <Link href="#" className="flex flexSpace align-center w100">بخش‌های بستری</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="#" className="flex flexSpace align-center w100">کلینیک‌ها</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="#" className="flex flexSpace align-center w100">پاراکلینیک‌ها</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="#" className="flex flexSpace align-center w100">پشتیبانی / اداری</Link>
                    </li>
                  </ul>
                  </div>
                  
                </div>
              )}

              {activeTab === "tab2" && (
                <div className="tabbox active">
                  <div className="tabpanel">
                      <ul className="publicList">
                    <li className="flex flexStart alignStart">
                      <Link href="/about" className="flex flexSpace align-center w100">درباره ما</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="/doctors" className="flex flexSpace align-center w100">پزشکان</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="/education" className="flex flexSpace align-center w100">آموزش به بیمار</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="/internationalPatients" className="flex flexSpace align-center w100">بیماران بین‌الملل</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="/research" className="flex flexSpace align-center w100">آموزش و پژوهش</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="/contact" className="flex flexSpace align-center w100">تماس با ما</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="/visitorsGuide" className="flex flexSpace align-center w100">راهنمای مراجعین</Link>
                    </li>
                  </ul>
                  </div>
                  
                </div>
              )}


              {activeTab === "tab3" && (
                <div className="tabbox active">
                  <div className="tabpanel">
                      <ul className="publicList">
                    <li className="flex flexStart alignStart">
                      <Link href="#" className="flex flexSpace align-center w100">راهنمای نوبت‌دهی آنلاین</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="#" className="flex flexSpace align-center w100">نوبت‌دهی کلینیک‌ها</Link>
                    </li>
                    <li className="flex flexStart alignStart">
                      <Link href="#" className="flex flexSpace align-center w100">نوبت‌دهی پاراکلینیک‌ها</Link>
                    </li>
                  </ul>
                  </div>                  
                </div>
              )}
            </div>
          </div>
      </Popup>
    </>
  );
}
