"use client";
import { useEffect } from "react";

export default function ScrollClassController({
  targetId,
  scrolledClass,
  offset = 0,
}: {
  targetId: string;
  scrolledClass: string;
  offset?: number;
}) {
  useEffect(() => {
    const el = document.getElementById(targetId);
    if (!el) return;

    const apply = () => {
      const y = window.scrollY || document.documentElement.scrollTop;
      if (y > offset) {
        el.classList.add(...scrolledClass.split(" "));
      } else {
        el.classList.remove(...scrolledClass.split(" "));
      }
    };

    apply();
    window.addEventListener("scroll", apply, { passive: true });
    return () => window.removeEventListener("scroll", apply);
  }, [targetId, scrolledClass, offset]);

  return null;
}
