"use client";

import Image from "next/image";
import Link from "next/link";
import { useRef, useState, useEffect } from "react";
import type { HomeAboutSection } from "@/src/types/home";
import { useCounter } from "@/src/hooks/home/useCounter";
import useOnScreen from "@/src/hooks/home/useOnScreen";

type AboutSectionProps = {
  about: HomeAboutSection;
};

function StatisticItem({ value, label }: { value: number; label: string }) {
  const { count, ref } = useCounter(value, 4000);

  return (
    <li className="StatisticsList_Item flex flexCenter alignCenter radius16 lightBgBlue overflow">
      <div className="flex flexDirColumn flexCenter alignCenter">
        <div
          ref={ref}
          className="count_Item radius6 bgGradiant whiteTxt txt14"
          aria-label={`${label} count`}
        >
          {count}+
        </div>
        <div className="darkTxt">
          <span>{label}</span>
        </div>
      </div>
    </li>
  );
}

export default function AboutHospital({ about }: AboutSectionProps) {
  const aboutCenterRef = useRef<HTMLDivElement>(null);
  const facilitiesRef = useRef<HTMLDivElement>(null);

  const isAboutCenterVisible = useOnScreen(aboutCenterRef);
  const isFacilitiesVisible = useOnScreen(facilitiesRef);

  return (
    <section className="secFour">
      <div className="mainSmall flex flexSpace alignStart aboutSec">

        <div className="aboutSec_r">
          <div className="publicTitle">
            <div className="topTitle flex flexDirColumn">
              <strong>
                <span>{about.title}</span>
                <label>{about.subtitle}</label>
              </strong>
            </div>
          </div>

          <div className="desc">
            <p>{about.description}</p>
          </div>

          <div className="allview">
            <Link
              href={about.link}
              className="radius40 greenBg whiteTxt flex flexCenter alignCenter w100 h100 animationGreenBox"
              aria-label="بیشتر درباره ما بدانید"
            >
              درباره ما بیشتر بدانید
            </Link>
          </div>
        </div>


        <div
          ref={aboutCenterRef}
          className={`aboutSec_c relative transition-all duration-700 ${
            isAboutCenterVisible ? "active" : ""
          }`}
        >
          <div className="aboutGallery">
            <ul className="relative">
              <li className="aboutGallery-smallerImg absolute flex flexCenter alignCenter">
                <figure>
                  <Image
                    src={about.gallery.smaller}
                    alt="تصویر گالری کوچک‌تر"
                    width={150}
                    height={150}
                    loading="lazy"
                  />
                </figure>
              </li>
              <li className="aboutGallery-bigImg absolute">
                <figure>
                  <Image
                    src={about.gallery.big}
                    alt="تصویر گالری بزرگ"
                    width={300}
                    height={300}
                    loading="lazy"
                  />
                </figure>
              </li>
              <li className="aboutGallery-smallImg absolute flex flexCenter alignCenter">
                <figure>
                  <Image
                    src={about.gallery.small}
                    alt="تصویر گالری کوچک"
                    width={200}
                    height={200}
                    loading="lazy"
                  />
                </figure>
              </li>
            </ul>
          </div>
        </div>


        <div
          ref={facilitiesRef}
          className={`aboutSec_l HospitalDepartments_facilities_List transition-all duration-700 ${
            isFacilitiesVisible ? "active" : ""
          }`}
        >
          <ul className="StatisticsList">
            {about.statistics.map((stat, idx) => (
              <StatisticItem key={idx} value={stat.value} label={stat.label} />
            ))}
          </ul>
        </div>
      </div>
    </section>
  );
}