"use client";
import Link from "next/link";
import Image from "next/image";
import type { HomeBlogsSection as NewsSectionType} from "@/src/types/home";

type NewsSectionProps = {
  news: NewsSectionType;
};

export default function NewsSection({ news }: NewsSectionProps) {
  const { topNews, newsList } = news;

  return (
    <section className="secNine">
      <div className="mainSmall">
       {/* Title */}
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter">
            <strong>
              <span>جدید‌ترین</span>
              <label>اخبار و رسانه‌ها</label>
            </strong>
            <div className="desc">
              <p>
                مرجع مقالات تخصصی، نکات پیشگیرانه و جدیدترین روش‌های درمانی برای
                ارتقای سلامت شما توسط متخصصان بیمارستان رضوی
              </p>
            </div>
          </div>
        </div>

        {/* News section */}
        <div className="blogSec flex flexSpace">
         {/* Big news */}
          <a className="topNews radius24 overflow relative" href={topNews.link}>
            {topNews.image && (
  <figure className="newsImg w100 h100">
    <Image
      src={topNews.image}
      alt={topNews.title || "news"}
      width={600}
      height={400}
      className="w100 h100 objectfitCover"
    />
  </figure>
)}
            <figcaption className="newsTxt absolute z-index w100 whiteTxt flex flexSpace alignStart">
              <div className="newsTxt_r">
                <div className="newsTitle">
                  <h3>{topNews.title}</h3>
                </div>
                <div className="newsTime flex flexStart alignCenter">
                  <i className="fa-regular fa-clock"></i>
                  <span>
                    زمان مطالعه :<label>{topNews.time}</label>
                  </span>
                </div>
              </div>
              <div className="newsTxt_l">
                <div className="borderWhite radius50 flex flexCenter alignCenter arrowIcon transition">
                  <i className="fa-solid fa-arrow-left-long arrowLeft"></i>
                </div>
              </div>
            </figcaption>
          </a>

         {/* Small news list */}
          <div className="newsList">
            <ul>
              {newsList.map((item) => (
                <li key={item.id}>
                  <a
                    href={item.link}
                    className="newsListItem flex flexSpace alignStart relative radius20 overflow borderGray"
                  >
                 {item.image && (
  <figure className="newsImg radius6 overflow">
    <Image
      src={item.image}
      alt={item.title}
      width={150}
      height={100}
      className="w100 h100 objectfitCover"
    />
  </figure>
)}

                    <figcaption className="newsDesc">
                      <div className="blueLbl blueTxt radius12 overflow">
                        <label>{item.category}</label>
                      </div>
                      <div className="newsTitle darkTxt">
                        <strong>{item.title}</strong>
                      </div>
                      <div className="date">
                        <i className="fa-regular fa-clock"></i>
                        <span>
                          زمان مطالعه :<label>{item.time}</label>
                        </span>
                      </div>
                      <div className="circleGreen radius50 flex flexCenter alignCenter txtGreen arrowIcon transition">
                        <i className="fa-solid fa-arrow-left-long arrowLeft"></i>
                      </div>
                    </figcaption>
                  </a>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* View All button */}
        <div className="allview flex flexCenter alignCenter">
          <Link
            href="/news"
            className="radius40 greenBg whiteTxt flex flexCenter alignCenter w100 h100 transition animationGreenBox"
          >
            مقالات بیشتر
          </Link>
        </div>
      </div>
    </section>
  );
}