"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Autoplay, Pagination } from "swiper/modules";
import { useRef, useEffect } from "react";
import Image from "next/image";
import { Fancybox } from "@fancyapps/ui";
import "@fancyapps/ui/dist/fancybox/fancybox.css";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

import type { HomeCertificatesSection as CertificateSectionType } from "@/src/types/home";

type CertificateProps = {
  certificatesData: CertificateSectionType;
};

export default function CertificateSection({ certificatesData }: CertificateProps) {
  const nextRef = useRef<HTMLDivElement | null>(null);
  const prevRef = useRef<HTMLDivElement | null>(null);

  useEffect(() => {
    Fancybox.bind("[data-fancybox='certificates']", {
      Thumbs: false,
      Toolbar: {
        display: ["close"],
      },
    });

    return () => {
      Fancybox.destroy();
    };
  }, []);

  return (
    <section className="secEight">
      <div className="mainSmall">
        {/* Title */}
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter">
            <strong>
              <span>{certificatesData.title}</span>
              <label>{certificatesData.subtitle}</label>
            </strong>
            <div className="desc">
              <p>{certificatesData.description}</p>
            </div>
          </div>
        </div>

        {/* Slider */}
        <div className="certificateSec relative">
          <Swiper
            modules={[Navigation, Autoplay, Pagination]}
            speed={900}
            slidesPerView={5}
            spaceBetween={10}
            autoplay={{
              delay: 6000,
              disableOnInteraction: false,
            }}
            pagination={{
              el: ".servicesPagination",
              clickable: true,
            }}
            navigation={{
              prevEl: prevRef.current,
              nextEl: nextRef.current,
            }}
            breakpoints={{
              300: { slidesPerView: 2, spaceBetween: 10 },
              480: { slidesPerView: 2, spaceBetween: 10 },
              720: { slidesPerView: 3, spaceBetween: 10 },
              1000: { slidesPerView: 5, spaceBetween: 10 },
            }}
            onInit={(swiper) => {
              // @ts-ignore
              swiper.params.navigation.prevEl = prevRef.current;
              // @ts-ignore
              swiper.params.navigation.nextEl = nextRef.current;
              swiper.navigation.init();
              swiper.navigation.update();
            }}
            className="certificateSlider"
          >
            {certificatesData.certificates.map((src, idx) => (
              <SwiperSlide
                key={idx}
                
              > <div className="certificateSlider_item relative flex flexCenter alignCenter">
                 <a
                  href={src}
                  data-fancybox="certificates"
                  className="certificateSlider_item_img flex flexCenter alignCenter"
                >
                  <Image
                    src={src}
                    alt={`certificate-${idx + 1}`}
                    width={200}
                    height={150}
                  />
                </a>
              </div>
               
              </SwiperSlide>
            ))}
          </Swiper>

          {/* Navigation buttons */}
          <div
            ref={prevRef}
            className="radius12 flex flexCenter alignCenter certificateSliderPrv publicBtn absolute"
          >
            <i className="fa-solid fa-angle-left"></i>
          </div>
          <div
            ref={nextRef}
            className="radius12 flex flexCenter alignCenter certificateSliderNxt publicBtn absolute"
          >
            <i className="fa-solid fa-chevron-right"></i>
          </div>
        </div>
      </div>
    </section>
  );
}
