"use client";
import Link from "next/link";
import { Swiper, SwiperSlide } from "swiper/react";
import { Pagination, Autoplay } from "swiper/modules";
import Image from "next/image";
import "swiper/css";
import "swiper/css/pagination";

type DoctorType = {
  id: string;
  slug: string;
  name: string;
  specialty: string;
  image: string;
};

type DoctorsSectionProps = {
  title: string;
  subtitle?: string;
  description?: string;
  doctors: DoctorType[];
  showAllButton?: boolean;
};

export default function DoctorsSection({
  title,
  subtitle,
  description,
  doctors,
  showAllButton = true,
}: DoctorsSectionProps) {
  return (
    <section className="secThree">
      <div className="mainSmall">
        {/* Section title */}
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter">
            <strong>
              <span>{title}</span>
              {subtitle && <label>{subtitle}</label>}
            </strong>
            {description && <p>{description}</p>}
          </div>
        </div>

        {/* Doctors Slider */}
        <Swiper
          modules={[Pagination, Autoplay]}
          spaceBetween={30}
          slidesPerView={4}
          autoplay={{ delay: 5000, disableOnInteraction: false }}
          pagination={{ clickable: true }}
          breakpoints={{
            300: { slidesPerView: 1, spaceBetween: 10 },
            480: { slidesPerView: 2, spaceBetween: 20 },
            720: { slidesPerView: 4, spaceBetween: 30 },
            1000: { slidesPerView: 4, spaceBetween: 30 },
          }}
          className="exportsListSlider"
        >
          {doctors.map((doctor) => (
            <SwiperSlide key={doctor.id}>
              <Link
                href={`/doctors/${doctor.slug}`}
                className="exportsListSlider_item"
              >
                <div className="exportsListSlider_item_img relative">
                  <figure className="relative hoverImg">
                    <Image
                      src={doctor.image}
                      alt={doctor.name}
                      width={300}
                      height={300}
                      className="w100 h100 objectfitCover"
                    />
                  </figure>
                </div>
                <figcaption className="exportsListSlider_item_title txtCenter">
                  <h2 className="darkTxt">{doctor.name}</h2>
                  <span className="txt12">{doctor.specialty}</span>
                </figcaption>
              </Link>
            </SwiperSlide>
          ))}
        </Swiper>

        {/* View All button */}
        {showAllButton && (
          <div className="allview">
            <Link
              href="/doctors"
              className="radius40 greenBg whiteTxt flex flexCenter alignCenter w100 h100 transition animationGreenBox"
            >
              همه پزشکان
            </Link>
          </div>
        )}
      </div>
    </section>
  );
}
