"use client";
import Image from "next/image";
import { Swiper, SwiperSlide } from "swiper/react";
import { Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/pagination";

import type { HomeBannersSection } from "@/src/types/home";

type HeroSliderProps = {
  heroSlider: HomeBannersSection;
};

export default function HeroSlider({ heroSlider }: HeroSliderProps) {

  const slides = (heroSlider?.items || []).filter(
    (s) => s?.src && s.src.trim() !== ""
  );


  if (!slides.length) return null;

  return (
    <section className="secOne" aria-label="اسلایدر اصلی">
      <div className="bannerHome relative">
        <Swiper
          modules={[Pagination, Autoplay]}
          pagination={{
            el: ".paginationSlider",
            clickable: true,
          }}
          autoplay={{ delay: 4000 }}
          loop
          speed={900}
          className="bannerHome_slider"
        >
          {slides.map((slide, i) => (
            <SwiperSlide key={slide.id || i}>
              <a href={slide.link || "#"} className="sliderItem w100 h100">
                <figure className="sliderItem_img w100 h100">
                  <Image
                    src={slide.src}
                    alt={slide.alt || slide.title || "slider image"}
                    width={1200}
                    height={600}
                    className="w100 h100 objectfitCover"
                  />
                </figure>

                {(slide.title || slide.desc) && (
                  <figcaption className="absolute">
                    <div className="sliderTitle">
                      {slide.title && <span>{slide.title}</span>}
                      {slide.desc && <p className="desc">{slide.desc}</p>}
                    </div>
                  </figcaption>
                )}
              </a>
            </SwiperSlide>
          ))}
        </Swiper>

        <div className="paginationSlider swiper-pagination" />
      </div>
    </section>
  );
}
