"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import type { Swiper as SwiperInstance } from "swiper";
import { useRef } from "react";
import Image from "next/image";

import "swiper/css";

import type { HomeInsurancesSection as InsuranceSectionType } from "@/src/types/home";

type InsuranceProps = {
  insurance: InsuranceSectionType;
};

export default function InsuranceSection({ insurance }: InsuranceProps) {
  const topSwiperRef = useRef<SwiperInstance | null>(null);
  const bottomSwiperRef = useRef<SwiperInstance | null>(null);

  // Common handle for buttons
  const handleNext = () => {
    topSwiperRef.current?.slideNext();
    bottomSwiperRef.current?.slideNext();
  };

  const handlePrev = () => {
    topSwiperRef.current?.slidePrev();
    bottomSwiperRef.current?.slidePrev();
  };

  return (
    <section className="secSeven">
      <div className="mainSmall insuranceSec">
        {/* عنوان */}
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter">
            <strong>
              <span>{insurance.title}</span>
              <label>{insurance.subtitle}</label>
            </strong>
            <div className="desc">
              <p>{insurance.description}</p>
            </div>
          </div>
        </div>

        {/* First row - 5 logos */}
        <Swiper
          slidesPerView={5}
          spaceBetween={20}
          breakpoints={{
            300: { slidesPerView: 3, spaceBetween: 10 },
            480: { slidesPerView: 3, spaceBetween: 12 },
            720: { slidesPerView: 4, spaceBetween: 15 },
            1001: { slidesPerView: 5, spaceBetween: 20 },
          }}
          onSwiper={(swiper) => (topSwiperRef.current = swiper)}
          className="insuranceList_slider swiper-top"
        >
          {insurance.topRow.map((src, idx) => (
            <SwiperSlide key={`top-${idx}`}>
              <a className="insuranceList_slider_item relative radius50 lightGrayBg flex flexCenter alignCenter">
                <Image src={src} alt={`بیمه ${idx + 1}`} width={80} height={80} />
              </a>
            </SwiperSlide>
          ))}
        </Swiper>

        {/* Second row - 4 logos */}
        <Swiper
          slidesPerView={4}
          spaceBetween={10}
          breakpoints={{
            300: { slidesPerView: 2, spaceBetween: 8 },
            480: { slidesPerView: 2, spaceBetween: 10 },
            720: { slidesPerView: 3, spaceBetween: 12 },
            1001: { slidesPerView: 4, spaceBetween: 10 },
          }}
          onSwiper={(swiper) => (bottomSwiperRef.current = swiper)}
          className="insuranceList_slider swiper-bottom"
        >
          {insurance.bottomRow.map((src, idx) => (
            <SwiperSlide key={`bottom-${idx}`}>
              <a className="insuranceList_slider_item relative radius50 lightGrayBg flex flexCenter alignCenter">
                <Image src={src} alt={`بیمه ${idx + 1}`} width={80} height={80} />
              </a>
            </SwiperSlide>
          ))}
        </Swiper>

       {/* Shared buttons */}
        <div className="navSlider flex flexEnd alignCenter z-index">
          <button
            type="button"
            onClick={handleNext}
            className="radius12 flex flexCenter alignCenter insuranceNxt publicBtn"
            aria-label="اسلاید بعدی"
          >
            <i className="fa-solid fa-chevron-right"></i>
          </button>
          <button
            type="button"
            onClick={handlePrev}
            className="radius12 flex flexCenter alignCenter insurancePrv publicBtn"
            aria-label="اسلاید قبلی"
          >
            <i className="fa-solid fa-angle-left"></i>
          </button>
        </div>
      </div>
    </section>
  );
}
