"use client";

import Image from "next/image";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

import type { HomeServicesSection } from "@/src/types/home";

type ServicesProps = {
  services: HomeServicesSection;
};

export default function ServicesSection({ services }: ServicesProps) {
  return (
    <section className="secTwo">
      <div className="mainSmall">

       {/* Title */}
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter">
            <strong>
              <span>{services.title}</span>
              <label>{services.subtitle}</label>
            </strong>
            <p>{services.description}</p>
          </div>
        </div>

        {/* Slider */}
        <Swiper
          modules={[Navigation, Pagination, Autoplay]}
          slidesPerView={4}
          spaceBetween={20}
          autoplay={{ delay: 5000, disableOnInteraction: false }}
          pagination={{ clickable: true }}
          navigation={{
            nextEl: ".services-next",
            prevEl: ".services-prev",
          }}
          breakpoints={{
            300: { slidesPerView: 1 },
            480: { slidesPerView: 2 },
            768: { slidesPerView: 3 },
            1024: { slidesPerView: 4 },
          }}
          className="servicesList servicesListSlider"
        >
          {services.items.map((item, index) => (
            <SwiperSlide key={index}>
              <div className="servicesList_item relative">
                <a href={item.link} className="bgWhite radius20 w100 h100">
                  {item.src ? (
                  <figure className="marginAuto">
                       <img src={item.src} alt={item.alt} width={80} height={80} /> 
                  </figure>
                   ) : null}
                  <div className="servicesList_item_title marginAuto">
                    <span className="darkTxt">{item.title}</span>
                  </div>
                  <div className="desc marginAuto txtCenter">
                    <p>{item.description}</p>
                  </div>
                </a>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>

        {/* Pagination Button*/}
        <div className="navSlider flex flexEnd alignCenter absolute z-index">
          <div className="radius12 flex flexCenter alignCenter nextBtn publicBtn services-next">
            <i className="fa-light fa-chevron-right"></i>
          </div>
          <div className="radius12 flex flexCenter alignCenter prevBtn publicBtn services-prev">
            <i className="fa-light fa-angle-left"></i>
          </div>
        </div>
      </div>
    </section>
  );
}
