"use client";

import Image from "next/image";
import type { HomePageData } from "@/src/types/home";

type SocialSectionProps = {
  socials: HomePageData["socialNetworks"];
};

export default function SocialSection({ socials }: SocialSectionProps) {
  return (
    <section className="fix socialSec transition z-index radius16">
      <div className="socialList">
        <ul>
          {socials.map((item, i) => (
            <li key={i}>
              <a
                href={item.url}
                target="_blank"
                rel="noopener noreferrer"
              >
                <Image
                  src={item.icon}
                  alt={item.title}
                  width={40}
                  height={40}
                />
              </a>
            </li>
          ))}
        </ul>
      </div>
    </section>
  );
}
