"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Autoplay, EffectCoverflow } from "swiper/modules";
import { useRef, useEffect } from "react";
import Image from "next/image";
import type { HomeCommentsSection } from "@/src/types/home";

import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/effect-coverflow";

type CommentsProps = {
  comments: HomeCommentsSection;
};

export default function Comments({ comments }: CommentsProps) {
  const prevRef = useRef<HTMLDivElement | null>(null);
  const nextRef = useRef<HTMLDivElement | null>(null);
  const swiperRef = useRef<any>(null);

  useEffect(() => {
    if (
      swiperRef.current &&
      swiperRef.current.params &&
      swiperRef.current.params.navigation
    ) {
      swiperRef.current.params.navigation.prevEl = prevRef.current;
      swiperRef.current.params.navigation.nextEl = nextRef.current;

      swiperRef.current.navigation.destroy();
      swiperRef.current.navigation.init();
      swiperRef.current.navigation.update();
    }
  }, []);

  return (
    <section className="secSix">
      <div className="mainSmall relative">
        {/* Title */}
        <div className="publicTitle">
          <div className="topTitle flex flexDirColumn alignCenter">
            <strong>
              <span>{comments.title}</span>
              <label>{comments.subtitle}</label>
            </strong>
            <div className="desc">
              <p>{comments.description}</p>
            </div>
          </div>
        </div>

        {/* Slider */}
        <Swiper
          modules={[Navigation, Autoplay, EffectCoverflow]}
          effect="coverflow"
          speed={900}
          grabCursor={true}
          centeredSlides={true}
          autoplay={{ delay: 6000, disableOnInteraction: false }}
          coverflowEffect={{
            rotate: 30,
            stretch: 0,
            depth: 100,
            modifier: 1,
            slideShadows: false,
          }}
          breakpoints={{
            300: { slidesPerView: 2, spaceBetween: 10 },
            480: { slidesPerView: 2, spaceBetween: 10 },
            720: { slidesPerView: 3, spaceBetween: 100 },
            1000: { slidesPerView: 3, spaceBetween: 100 },
          }}
          spaceBetween={100}
          slidesPerView={3}
          onSwiper={(swiper) => (swiperRef.current = swiper)}
          className="commentListSlider"
        >
          {comments.items.map((item, idx) => (
            <SwiperSlide key={idx}>
              <div className="commentListSlider_item flex flexDirColumn alignCenter relative transition radius20">
                <figure className="userImg radius50 overflow absolute">
                  <Image
  src={item.picture}
  alt={item.fullName}
  width={80}
  height={80}
  className="w100 h100 objectfitCover"
/>
                </figure>
                <div className="userTitle flex flexDirColumn alignCenter">
                  <strong className="darkTxt">{item.fullName}</strong>
                </div>
                <div className="desc txtCenter">
                  <p>{item.comment}</p>
                </div>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>

        {/* Navigation buttons */}
        <div className="navSlider flex flexCenter alignCenter absolute z-index w100">
          
          <div
            ref={nextRef}
            className="radius12 flex flexCenter alignCenter commentListSliderNxt publicBtn"
          >
            <i className="fa-solid fa-chevron-right"></i>
          </div>
          <div
            ref={prevRef}
            className="radius12 flex flexCenter alignCenter commentListSliderPrev publicBtn"
          >
            <i className="fa-solid fa-angle-left"></i>
          </div>
        </div>
      </div>
    </section>
  );
}
