"use client";

import { MapContainer, TileLayer, Marker, Popup } from "react-leaflet";
import "leaflet/dist/leaflet.css";
import L from "leaflet";
import { useEffect } from "react";

const defaultIcon = L.icon({
  iconUrl: "/images/marker-icon.png",
  shadowUrl: "/images/marker-shadow.png",
  iconSize: [25, 41],
  iconAnchor: [12, 41],
});

type Props = {
  latitude: string | undefined;
  longitude: string | undefined;
};

export default function ContactMap({ latitude, longitude }: Props) {
  useEffect(() => {
    (L.Marker.prototype as any).options.icon = defaultIcon;
  }, []);

  const lat = Number(latitude ?? 0);
  const lng = Number(longitude ?? 0);

  if (isNaN(lat) || isNaN(lng)) {
    console.error("❌ Invalid coordinates:", latitude, longitude);

    return (
      <div
        style={{
          width: "100%",
          height: "420px",
          display: "flex",
          alignItems: "center",
          justifyContent: "center",
          background: "#f7f7f7",
          borderRadius: "20px",
        }}
      >
        مختصات نقشه نامعتبر است
      </div>
    );
  }

  return (
    <MapContainer
      center={[lat, lng]}
      zoom={15}
      style={{ width: "100%", height: "420px" }}
      scrollWheelZoom={false}
      className="radius20 overflow-hidden"
    >
      <TileLayer
        attribution='&copy; OpenStreetMap'
        url="https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png"
      />

      <Marker position={[lat, lng]}>
        <Popup>بیمارستان رضوی</Popup>
      </Marker>
    </MapContainer>
  );
}
