"use client";

type Props = {
  neshan: string;
  google: string;
  waze: string;
};

export default function MapRoutingList({ neshan, google, waze }: Props) {
  return (
    <div className="mapRoutingList absolute">
      <ul>
        <li>
          <a
            href={neshan}
            target="_blank"
            className="mapRoutingList_item flex flexCenter alignCenter radius12 borderGray overflow bgWhite"
          >
            <img src="/images/neshan.png" alt="مسیر یابی با نشان" />
            <span>مسیر یابی با نشان</span>
          </a>
        </li>

        <li>
          <a
            href={google}
            target="_blank"
            className="mapRoutingList_item flex flexCenter alignCenter radius12 borderGray overflow bgWhite"
          >
            <img src="/images/googleMap.png" alt="مسیر یابی با گوگل" />
            <span>مسیر یابی با گوگل</span>
          </a>
        </li>

        <li>
          <a
            href={waze}
            target="_blank"
            className="mapRoutingList_item flex flexCenter alignCenter radius12 borderGray overflow bgWhite"
          >
            <img src="/images/viz.png" alt="مسیر یابی با ویز" />
            <span>مسیر یابی با ویز</span>
          </a>
        </li>
      </ul>
    </div>
  );
}
